/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.teamfruit.emojicord.compat.Compat;

public class CompatChat {

    public static enum CompatTextFormatting {
        BLACK(TextFormatting.BLACK),
        DARK_BLUE(TextFormatting.DARK_BLUE),
        DARK_GREEN(TextFormatting.DARK_GREEN),
        DARK_AQUA(TextFormatting.DARK_AQUA),
        DARK_RED(TextFormatting.DARK_RED),
        DARK_PURPLE(TextFormatting.DARK_PURPLE),
        GOLD(TextFormatting.GOLD),
        GRAY(TextFormatting.GRAY),
        DARK_GRAY(TextFormatting.DARK_GRAY),
        BLUE(TextFormatting.BLUE),
        GREEN(TextFormatting.GREEN),
        AQUA(TextFormatting.AQUA),
        RED(TextFormatting.RED),
        LIGHT_PURPLE(TextFormatting.LIGHT_PURPLE),
        YELLOW(TextFormatting.YELLOW),
        WHITE(TextFormatting.WHITE),
        OBFUSCATED(TextFormatting.OBFUSCATED),
        BOLD(TextFormatting.BOLD),
        STRIKETHROUGH(TextFormatting.STRIKETHROUGH),
        UNDERLINE(TextFormatting.UNDERLINE),
        ITALIC(TextFormatting.ITALIC),
        RESET(TextFormatting.RESET);

        public final TextFormatting format;

        private CompatTextFormatting(TextFormatting format) {
            this.format = format;
        }

        public String toString() {
            return this.format.toString();
        }
    }

    public static class CompatChatLine {
        public static CompatTextComponent getChatComponent(ChatLine line) {
            return new CompatTextComponent(line.func_151461_a());
        }
    }

    public static class CompatTextStyle {
        public final Style style;

        public CompatTextStyle(Style style) {
            this.style = style;
        }

        public CompatTextStyle setColor(CompatTextFormatting format) {
            this.style.func_150238_a(format.format);
            return this;
        }

        public static CompatTextStyle create() {
            return new CompatTextStyle(new Style());
        }

        public CompatTextStyle setChatHoverEvent(CompatHoverEvent event) {
            this.style.func_150209_a(event.event);
            return this;
        }

        public CompatTextStyle setChatClickEvent(CompatClickEvent event) {
            this.style.func_150241_a(event.event);
            return this;
        }
    }

    public static class CompatHoverEvent {
        public final HoverEvent event;

        public CompatHoverEvent(HoverEvent event) {
            this.event = event;
        }

        public static CompatHoverEvent create(CompatAction action, CompatTextComponent text) {
            return new CompatHoverEvent(new HoverEvent(action.action, text.component));
        }

        public static enum CompatAction {
            SHOW_TEXT(HoverEvent.Action.SHOW_TEXT),
            SHOW_ITEM(HoverEvent.Action.SHOW_ITEM);

            public final HoverEvent.Action action;

            private CompatAction(HoverEvent.Action action) {
                this.action = action;
            }
        }
    }

    public static class CompatClickEvent {
        private final ClickEvent event;

        public CompatClickEvent(ClickEvent event) {
            this.event = event;
        }

        public String getValue() {
            return this.event.func_150668_b();
        }

        public static CompatClickEvent create(CompatAction action, String text) {
            return new CompatClickEvent(new ClickEvent(action.action, text));
        }

        public static enum CompatAction {
            OPEN_URL(ClickEvent.Action.OPEN_URL),
            OPEN_FILE(ClickEvent.Action.OPEN_FILE),
            RUN_COMMAND(ClickEvent.Action.RUN_COMMAND),
            SUGGEST_COMMAND(ClickEvent.Action.SUGGEST_COMMAND);

            public final ClickEvent.Action action;

            private CompatAction(ClickEvent.Action action) {
                this.action = action;
            }
        }
    }

    public static class CompatTextComponent {
        public static CompatTextComponent blank = CompatTextComponent.fromText("");
        public final ITextComponent component;

        public CompatTextComponent(ITextComponent component) {
            this.component = component;
        }

        @Nonnull
        public List<CompatClickEvent> getLinksFromChat() {
            LinkedList list = Lists.newLinkedList();
            this.getLinksFromChat0(list, this.component);
            return list;
        }

        private void getLinksFromChat0(@Nonnull List<CompatClickEvent> list, @Nonnull ITextComponent pchat) {
            List chats = pchat.func_150253_a();
            for (Object o : chats) {
                ITextComponent chat = (ITextComponent)o;
                ClickEvent ev = chat.func_150256_b().func_150235_h();
                if (ev != null && ev.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                    list.add(new CompatClickEvent(ev));
                }
                this.getLinksFromChat0(list, chat);
            }
        }

        public CompatTextComponent setChatStyle(CompatTextStyle style) {
            this.component.func_150255_a(style.style);
            return this;
        }

        public String getUnformattedText() {
            return this.component.func_150260_c();
        }

        public static CompatTextComponent jsonToComponent(String json) {
            return new CompatTextComponent(ITextComponent.Serializer.func_150699_a((String)json));
        }

        public static CompatTextComponent fromText(String text) {
            return new CompatTextComponent((ITextComponent)new TextComponentString(text));
        }

        public static CompatTextComponent fromTranslation(String text, Object ... params) {
            return new CompatTextComponent((ITextComponent)new TextComponentTranslation(text, params));
        }

        public void sendClient() {
            Compat.CompatMinecraft.getMinecraft().getMinecraftObj().field_71456_v.func_146158_b().func_146227_a(this.component);
        }

        public void sendClientWithId(int id) {
            Compat.CompatMinecraft.getMinecraft().getMinecraftObj().field_71456_v.func_146158_b().func_146234_a(this.component, id);
        }

        public void sendPlayer(@Nonnull ICommandSender target) {
            target.func_145747_a(this.component);
        }
    }
}

