/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;

public class CompatConfig {

    public static class CompatConfigElement {
        public final IConfigElement element;

        public CompatConfigElement(IConfigElement element) {
            this.element = element;
        }

        public static List<IConfigElement> getConfigElements(List<CompatConfigElement> elements) {
            return Lists.transform(elements, t -> t == null ? null : t.element);
        }

        public static CompatConfigElement fromCategory(CompatConfigCategory category) {
            return new CompatConfigElement((IConfigElement)new ConfigElement(category.category));
        }

        public static CompatConfigElement fromProperty(CompatConfigProperty prop) {
            return new CompatConfigElement((IConfigElement)new ConfigElement(prop.property));
        }
    }

    public static class CompatConfigProperty {
        public final Property property;

        public CompatConfigProperty(Property property) {
            this.property = property;
        }
    }

    public static class CompatConfigCategory {
        public final ConfigCategory category;

        public CompatConfigCategory(ConfigCategory category) {
            this.category = category;
        }

        public boolean isChild() {
            return this.category.isChild();
        }
    }

    public static class CompatConfiguration {
        public final Configuration config;

        public CompatConfiguration(Configuration config) {
            this.config = config;
        }

        public Set<String> getCategoryNames() {
            return this.config.getCategoryNames();
        }

        public CompatConfigCategory getCategory(String category) {
            return new CompatConfigCategory(this.config.getCategory(category));
        }
    }
}

