/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.teamfruit.emojicord.CoreEvent;
import net.teamfruit.emojicord.compat.ClientChatEvent;
import net.teamfruit.emojicord.compat.CompatGui;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class CompatEvents {

    public static class CompatConfigChangedEvent
    extends CompatEvent<ConfigChangedEvent> {
        public CompatConfigChangedEvent(ConfigChangedEvent event) {
            super(event);
        }

        public String getModId() {
            return ((ConfigChangedEvent)this.event).getModID();
        }

        public static class CompatOnConfigChangedEvent
        extends CompatConfigChangedEvent {
            public CompatOnConfigChangedEvent(ConfigChangedEvent event) {
                super(event);
            }
        }
    }

    public static class CompatGuiScreenEvent<T extends GuiScreenEvent>
    extends CompatEvent<T> {
        public CompatGuiScreenEvent(T event) {
            super(event);
        }

        public CompatGui.CompatScreen getGui() {
            return new CompatGui.CompatScreen(((GuiScreenEvent)this.event).getGui());
        }

        public static class CompatKeyboardKeyPressedEvent
        extends CompatGuiScreenEvent<GuiScreenEvent.KeyboardInputEvent> {
            private final int keycode;

            public CompatKeyboardKeyPressedEvent(GuiScreenEvent.KeyboardInputEvent event, int keycode) {
                super(event);
                this.keycode = keycode;
            }

            public int getKeyCode() {
                return this.keycode;
            }

            public static class CompatPre
            extends CompatKeyboardKeyPressedEvent {
                public CompatPre(GuiScreenEvent.KeyboardInputEvent.Pre event, int keycode) {
                    super((GuiScreenEvent.KeyboardInputEvent)event, keycode);
                }
            }
        }

        public static class CompatKeyboardCharTypedEvent
        extends CompatGuiScreenEvent<GuiScreenEvent.KeyboardInputEvent> {
            private final char codePoint;
            private final int modifiers;

            public CompatKeyboardCharTypedEvent(GuiScreenEvent.KeyboardInputEvent event, char codePoint, int modifiers) {
                super(event);
                this.codePoint = codePoint;
                this.modifiers = modifiers;
            }

            public char getCodePoint() {
                return this.codePoint;
            }

            public int getModifiers() {
                return this.modifiers;
            }

            public static class CompatPre
            extends CompatKeyboardCharTypedEvent {
                public CompatPre(GuiScreenEvent.KeyboardInputEvent.Pre event, char codePoint, int modifiers) {
                    super((GuiScreenEvent.KeyboardInputEvent)event, codePoint, modifiers);
                }
            }
        }

        public static class CompatMouseScrollEvent
        extends CompatGuiScreenEvent<GuiScreenEvent.MouseInputEvent> {
            private final double scrollDelta;

            public CompatMouseScrollEvent(GuiScreenEvent.MouseInputEvent event, double scrollDelta) {
                super(event);
                this.scrollDelta = scrollDelta;
            }

            public double getScrollDelta() {
                return this.scrollDelta;
            }

            public static class CompatPre
            extends CompatMouseScrollEvent {
                public CompatPre(GuiScreenEvent.MouseInputEvent.Pre event, double scrollDelta) {
                    super((GuiScreenEvent.MouseInputEvent)event, scrollDelta);
                }
            }
        }

        public static class CompatMouseReleasedEvent
        extends CompatGuiScreenEvent<GuiScreenEvent.MouseInputEvent> {
            private final int button;

            public CompatMouseReleasedEvent(GuiScreenEvent.MouseInputEvent event, int button) {
                super(event);
                this.button = button;
            }

            public int getButton() {
                return this.button;
            }

            public static class CompatPre
            extends CompatMouseReleasedEvent {
                public CompatPre(GuiScreenEvent.MouseInputEvent.Pre event, int button) {
                    super((GuiScreenEvent.MouseInputEvent)event, button);
                }
            }
        }

        public static class CompatMouseClickedEvent
        extends CompatGuiScreenEvent<GuiScreenEvent.MouseInputEvent> {
            private final int button;

            public CompatMouseClickedEvent(GuiScreenEvent.MouseInputEvent event, int button) {
                super(event);
                this.button = button;
            }

            public int getButton() {
                return this.button;
            }

            public static class CompatPre
            extends CompatMouseClickedEvent {
                public CompatPre(GuiScreenEvent.MouseInputEvent.Pre event, int button) {
                    super((GuiScreenEvent.MouseInputEvent)event, button);
                }
            }
        }

        public static class CompatInitGuiEvent
        extends CompatGuiScreenEvent<GuiScreenEvent.InitGuiEvent> {
            public CompatInitGuiEvent(GuiScreenEvent.InitGuiEvent event) {
                super(event);
            }

            public static class CompatPost
            extends CompatInitGuiEvent {
                public CompatPost(GuiScreenEvent.InitGuiEvent.Post event) {
                    super((GuiScreenEvent.InitGuiEvent)event);
                }
            }
        }

        public static class CompatDrawScreenEvent
        extends CompatGuiScreenEvent<GuiScreenEvent.DrawScreenEvent> {
            public CompatDrawScreenEvent(GuiScreenEvent.DrawScreenEvent event) {
                super(event);
            }

            public int getMouseX() {
                return ((GuiScreenEvent.DrawScreenEvent)this.event).getMouseX();
            }

            public int getMouseY() {
                return ((GuiScreenEvent.DrawScreenEvent)this.event).getMouseY();
            }

            public float getRenderPartialTicks() {
                return ((GuiScreenEvent.DrawScreenEvent)this.event).getRenderPartialTicks();
            }

            public static class CompatPost
            extends CompatDrawScreenEvent {
                public CompatPost(GuiScreenEvent.DrawScreenEvent.Post event) {
                    super((GuiScreenEvent.DrawScreenEvent)event);
                }
            }
        }
    }

    public static class CompatRenderGameOverlayEvent<T extends RenderGameOverlayEvent>
    extends CompatEvent<T> {
        public CompatRenderGameOverlayEvent(T event) {
            super(event);
        }

        public CompatElementType getType() {
            return CompatElementType.getType(((RenderGameOverlayEvent)this.event).getType());
        }

        public float getPartialTicks() {
            return ((RenderGameOverlayEvent)this.event).getPartialTicks();
        }

        public static enum CompatElementType {
            CHAT,
            EXPERIENCE,
            OTHER;


            public static CompatElementType getType(RenderGameOverlayEvent.ElementType type) {
                if (type == null) {
                    return OTHER;
                }
                switch (type) {
                    case CHAT: {
                        return CHAT;
                    }
                    case EXPERIENCE: {
                        return EXPERIENCE;
                    }
                }
                return OTHER;
            }
        }

        public static class CompatText
        extends CompatRenderGameOverlayEvent<RenderGameOverlayEvent.Text> {
            public CompatText(RenderGameOverlayEvent.Text event) {
                super(event);
            }

            public List<String> getLeft() {
                return ((RenderGameOverlayEvent.Text)this.event).getLeft();
            }
        }

        public static class CompatPost
        extends CompatRenderGameOverlayEvent<RenderGameOverlayEvent> {
            public CompatPost(RenderGameOverlayEvent event) {
                super(event);
            }
        }
    }

    public static class CompatClientTickEvent
    extends CompatEvent<TickEvent.ClientTickEvent> {
        public CompatClientTickEvent(TickEvent.ClientTickEvent event) {
            super(event);
        }

        public CompatPhase getPhase() {
            return CompatPhase.getPhase(((TickEvent.ClientTickEvent)this.event).phase);
        }

        public static enum CompatPhase {
            START,
            END;


            public static CompatPhase getPhase(TickEvent.Phase phase) {
                switch (phase) {
                    case START: {
                        return START;
                    }
                }
                return END;
            }
        }
    }

    public static class CompatClientChatEvent
    extends CompatEvent<ClientChatEvent> {
        public CompatClientChatEvent(ClientChatEvent event) {
            super(event);
        }

        public String getMessage() {
            return ((ClientChatEvent)this.event).getMessage();
        }

        public String getOriginalMessage() {
            return ((ClientChatEvent)this.event).getOriginalMessage();
        }

        public void setMessage(String message) {
            ((ClientChatEvent)this.event).setMessage(message);
        }
    }

    public static class CompatEvent<T extends Event> {
        protected final T event;

        public CompatEvent(T event) {
            this.event = event;
        }

        public void setCanceled(boolean cancel) {
            this.event.setCanceled(cancel);
        }
    }

    public static abstract class CompatHandler {
        private final Map<Integer, Integer> lwjgl2glfwKeyMappings = ((Supplier<Map>)() -> {
            HashMap map = Maps.newHashMap();
            map.put(205, 262);
            map.put(203, 263);
            map.put(208, 264);
            map.put(200, 265);
            map.put(15, 258);
            map.put(28, 257);
            map.put(156, 335);
            map.put(1, 256);
            return map;
        }).get();

        public void registerHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onChat(@Nonnull ClientChatEvent event) {
            this.onChat(new CompatClientChatEvent(event));
        }

        @CoreEvent
        public abstract void onChat(@Nonnull CompatClientChatEvent var1);

        @SubscribeEvent
        public void onTick(@Nonnull TickEvent.ClientTickEvent event) {
            this.onTick(new CompatClientTickEvent(event));
        }

        @CoreEvent
        public abstract void onTick(@Nonnull CompatClientTickEvent var1);

        @SubscribeEvent
        public void onDraw(@Nonnull RenderGameOverlayEvent.Post event) {
            this.onDraw(new CompatRenderGameOverlayEvent.CompatPost((RenderGameOverlayEvent)event));
        }

        @CoreEvent
        public abstract void onDraw(@Nonnull CompatRenderGameOverlayEvent.CompatPost var1);

        @SubscribeEvent
        public void onText(@Nonnull RenderGameOverlayEvent.Text event) {
            this.onText(new CompatRenderGameOverlayEvent.CompatText(event));
        }

        @CoreEvent
        public abstract void onText(@Nonnull CompatRenderGameOverlayEvent.CompatText var1);

        @SubscribeEvent
        public void onDraw(@Nonnull GuiScreenEvent.DrawScreenEvent.Post event) {
            this.onDraw(new CompatGuiScreenEvent.CompatDrawScreenEvent.CompatPost(event));
        }

        @CoreEvent
        public abstract void onDraw(@Nonnull CompatGuiScreenEvent.CompatDrawScreenEvent.CompatPost var1);

        @SubscribeEvent
        public void onInitGui(@Nonnull GuiScreenEvent.InitGuiEvent.Post event) {
            this.onInitGui(new CompatGuiScreenEvent.CompatInitGuiEvent.CompatPost(event));
        }

        @CoreEvent
        public abstract void onInitGui(@Nonnull CompatGuiScreenEvent.CompatInitGuiEvent.CompatPost var1);

        @SubscribeEvent
        public void onMouseClicked(@Nonnull GuiScreenEvent.MouseInputEvent.Pre event) {
            int button = Mouse.getEventButton();
            if (button >= 0) {
                if (Mouse.getEventButtonState()) {
                    this.onMouseClicked(new CompatGuiScreenEvent.CompatMouseClickedEvent.CompatPre(event, button));
                } else {
                    this.onMouseReleased(new CompatGuiScreenEvent.CompatMouseReleasedEvent.CompatPre(event, button));
                }
            }
        }

        @CoreEvent
        public abstract void onMouseClicked(@Nonnull CompatGuiScreenEvent.CompatMouseClickedEvent.CompatPre var1);

        @CoreEvent
        public abstract void onMouseReleased(@Nonnull CompatGuiScreenEvent.CompatMouseReleasedEvent.CompatPre var1);

        @SubscribeEvent
        public void onMouseScroll(@Nonnull GuiScreenEvent.MouseInputEvent.Pre event) {
            int dwheel = Integer.valueOf(Mouse.getEventDWheel()).compareTo(0);
            if (dwheel != 0) {
                this.onMouseScroll(new CompatGuiScreenEvent.CompatMouseScrollEvent.CompatPre(event, (double)dwheel));
            }
        }

        @CoreEvent
        public abstract void onMouseScroll(@Nonnull CompatGuiScreenEvent.CompatMouseScrollEvent.CompatPre var1);

        @SubscribeEvent
        public void onKeyPressed(@Nonnull GuiScreenEvent.KeyboardInputEvent.Pre event) {
            if (Keyboard.getEventKeyState()) {
                char eventChar = Keyboard.getEventCharacter();
                int eventKey = Keyboard.getEventKey();
                this.onCharTyped(new CompatGuiScreenEvent.CompatKeyboardCharTypedEvent.CompatPre(event, eventChar, eventKey));
                Integer key = this.lwjgl2glfwKeyMappings.get(eventKey);
                if (key != null) {
                    this.onKeyPressed(new CompatGuiScreenEvent.CompatKeyboardKeyPressedEvent.CompatPre(event, (int)key));
                }
            }
        }

        @CoreEvent
        public abstract void onKeyPressed(@Nonnull CompatGuiScreenEvent.CompatKeyboardKeyPressedEvent.CompatPre var1);

        @CoreEvent
        public abstract void onCharTyped(@Nonnull CompatGuiScreenEvent.CompatKeyboardCharTypedEvent.CompatPre var1);

        @SubscribeEvent
        public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
            this.onConfigChanged(new CompatConfigChangedEvent.CompatOnConfigChangedEvent((ConfigChangedEvent)event));
        }

        @CoreEvent
        public abstract void onConfigChanged(@Nonnull CompatConfigChangedEvent.CompatOnConfigChangedEvent var1);
    }
}

