/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.teamfruit.emojicord.compat.Compat;
import net.teamfruit.emojicord.compat.CompatConfig;

public class CompatGui {

    public static abstract class CompatModGuiFactory
    implements IModGuiFactory {
        public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
            return null;
        }

        public IModGuiFactory.RuntimeOptionGuiHandler getHandlerFor(IModGuiFactory.RuntimeOptionCategoryElement element) {
            return null;
        }

        @Nullable
        public Class<? extends GuiScreen> mainConfigGuiClass() {
            return this.mainConfigGuiClassCompat();
        }

        @Nullable
        public abstract Class<?> mainConfigGuiClassCompat();

        public abstract CompatScreen createConfigGuiCompat(CompatScreen var1);
    }

    public static class CompatGuiConfig
    extends GuiConfig {
        public CompatGuiConfig(CompatScreen parentScreen, List<CompatConfig.CompatConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title) {
            super(parentScreen.getScreenObj(), CompatConfig.CompatConfigElement.getConfigElements(configElements), modID, allRequireWorldRestart, allRequireMcRestart, GuiConfig.getAbridgedConfigPath((String)title));
        }
    }

    public static class CompatTextFieldWidget {
        private final GuiTextField textField;
        private final Compat.CompatFontRenderer font;

        public CompatTextFieldWidget(GuiTextField inputField) {
            this.textField = inputField;
            this.font = Compat.CompatMinecraft.getMinecraft().getFontRenderer();
        }

        public CompatTextFieldWidget(Compat.CompatFontRenderer font, int x, int y, int width, int height, String title) {
            this(new GuiTextField(-1, font.getFontRendererObj(), x, y, width, height));
        }

        public GuiTextField getTextFieldWidgetObj() {
            return this.textField;
        }

        public String getText() {
            return this.textField.func_146179_b();
        }

        public void setText(String apply) {
            this.textField.func_146180_a(apply);
        }

        public int getInsertPos(int start) {
            String text = this.textField.func_146179_b();
            if (start > text.length()) {
                return this.textField.field_146209_f;
            }
            return this.textField.field_146209_f + this.font.getStringWidth(text.substring(0, start));
        }

        public void setSuggestion(String string) {
            try {
                this.textField.getClass().getField("suggestion").set(this.textField, string);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Could not set suggestion: ", e);
            }
        }

        public int getCursorPosition() {
            return this.textField.func_146198_h();
        }

        public void setCursorPosition(int i) {
            this.textField.func_146190_e(i);
        }

        public void setSelectionPos(int i) {
            this.textField.func_146199_i(i);
        }

        public void setMaxStringLength(int length) {
            this.textField.func_146203_f(length);
        }

        public void setEnableBackgroundDrawing(boolean enabled) {
            this.textField.func_146185_a(enabled);
        }

        public void changeFocus(boolean active) {
            this.textField.func_146195_b(active);
        }

        public void setFocused(boolean focused) {
            this.textField.func_146195_b(focused);
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            this.textField.func_146192_a(mouseX, mouseY, button);
            return this.textField.field_146209_f <= mouseX && mouseX <= this.textField.field_146209_f + this.textField.field_146218_h && this.textField.field_146210_g <= mouseY && mouseY <= this.textField.field_146210_g + this.textField.field_146219_i;
        }

        public boolean charTyped(char typed, int keycode) {
            return this.textField.func_146201_a(typed, keycode);
        }

        public boolean keyPressed(int keycode, int mouseX, int mouseY) {
            return true;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.textField.func_146194_f();
        }

        public void tick() {
            this.textField.func_146178_a();
        }

        public void writeText(String string) {
            this.textField.func_146191_b(string);
        }

        public static void renderSuggestion(FontRenderer font, boolean flag, String suggestion, int posX, int posY) {
            if (!flag && suggestion != null) {
                font.func_175063_a(suggestion, (float)(posX - 1), (float)posY, -8355712);
            }
        }
    }

    public static class CompatChatScreen {
        private final GuiChat chatScreen;

        public CompatChatScreen(GuiChat chatScreen) {
            this.chatScreen = chatScreen;
        }

        public CompatTextFieldWidget getTextField() {
            return new CompatTextFieldWidget(this.chatScreen.field_146415_a);
        }

        @Nonnull
        public CompatScreen cast() {
            return new CompatScreen((GuiScreen)this.chatScreen);
        }

        @Nullable
        public static CompatChatScreen cast(CompatScreen screen) {
            if (screen.screen instanceof GuiChat) {
                return new CompatChatScreen((GuiChat)screen.screen);
            }
            return null;
        }
    }

    public static class CompatScreen {
        private GuiScreen screen;

        public CompatScreen(GuiScreen screen) {
            this.screen = screen;
        }

        public CompatScreen(CompatGuiConfig screen) {
            this.screen = screen;
        }

        public GuiScreen getScreenObj() {
            return this.screen;
        }

        public int getWidth() {
            return this.screen.field_146294_l;
        }

        public int getHeight() {
            return this.screen.field_146295_m;
        }

        public static boolean hasShiftDown() {
            return GuiScreen.func_146272_n();
        }
    }

    public static class CompatGuiNewChat {
        public static int getChatWidth(GuiNewChat chat) {
            return chat.func_146228_f();
        }

        public static float getChatScale(GuiNewChat chat) {
            return chat.func_146244_h();
        }
    }
}

