/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySignRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketUpdateSign;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.teamfruit.emojicord.compat.CompatChat;
import org.apache.commons.lang3.Validate;

public class CompatSign {

    public static class CompatBakedModel {
        public final IBakedModel bakedModel;

        public CompatBakedModel(@Nonnull IBakedModel bakedModel) {
            this.bakedModel = bakedModel;
        }
    }

    public static class CompatModel {
        public final IModel model;

        public CompatModel(@Nonnull IModel model) {
            this.model = model;
        }
    }

    public static class CompatChatRender {

        public static abstract class CompatPicChatLine
        extends ChatLine {
            @Nonnull
            public static final CompatChat.CompatTextComponent dummytext = CompatChat.CompatTextComponent.fromText("");

            public CompatPicChatLine(int updateCounterCreated, int lineId) {
                super(updateCounterCreated, CompatPicChatLine.dummytext.component, lineId);
            }

            @Nullable
            public ITextComponent onClicked(@Nonnull GuiNewChat chat, int x) {
                CompatChat.CompatTextComponent component = this.onClickedCompat(chat, x);
                if (component != null) {
                    return component.component;
                }
                return null;
            }

            @Nullable
            public abstract CompatChat.CompatTextComponent onClickedCompat(@Nonnull GuiNewChat var1, int var2);
        }
    }

    public static enum CompatEnumFacing {
        DOWN(0, -1, 0, EnumFacing.DOWN),
        UP(0, 1, 0, EnumFacing.UP),
        NORTH(0, 0, -1, EnumFacing.NORTH),
        SOUTH(0, 0, 1, EnumFacing.SOUTH),
        WEST(-1, 0, 0, EnumFacing.WEST),
        EAST(1, 0, 0, EnumFacing.EAST);

        public final int offsetX;
        public final int offsetY;
        public final int offsetZ;
        private final EnumFacing facing;

        private CompatEnumFacing(int offsetX, int offsetY, int offsetZ, EnumFacing facing) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.facing = facing;
        }

        public int getIndex() {
            return this.ordinal();
        }

        @Nonnull
        public static CompatEnumFacing fromFacing(@Nonnull EnumFacing facing) {
            for (CompatEnumFacing cfacing : CompatEnumFacing.values()) {
                if (facing != cfacing.facing) continue;
                return cfacing;
            }
            return DOWN;
        }

        @Nonnull
        public static CompatEnumFacing fromFacingId(int facing) {
            CompatEnumFacing[] cfacings = CompatEnumFacing.values();
            if (0 <= facing && facing < cfacings.length) {
                return cfacings[facing];
            }
            return DOWN;
        }
    }

    public static class CompatTileEntitySign {
        public static List<CompatChat.CompatTextComponent> getSignText(TileEntitySign tile) {
            return Lists.transform((List)Lists.newArrayList((Object[])tile.field_145915_a), t -> new CompatChat.CompatTextComponent((ITextComponent)t));
        }

        public static void setSignText(TileEntitySign tile, List<CompatChat.CompatTextComponent> clines) {
            List lines = Lists.transform(clines, t -> t == null ? null : t.component);
            Iterator itr = lines.iterator();
            for (int i = 0; i < tile.field_145915_a.length; ++i) {
                tile.field_145915_a[i] = itr.hasNext() ? (ITextComponent)itr.next() : CompatChat.CompatTextComponent.blank.component;
            }
        }
    }

    public static class CompatC17PacketCustomPayload
    extends CompatPacket {
        public CompatC17PacketCustomPayload(CPacketCustomPayload packet) {
            super((Packet<? extends INetHandler>)packet);
        }

        public static CompatC17PacketCustomPayload create(String channel, String data) {
            return new CompatC17PacketCustomPayload(new CPacketCustomPayload(channel, new PacketBuffer(Unpooled.buffer()).func_180714_a(data)));
        }
    }

    public static class CompatC12PacketUpdateSign
    extends CompatPacket {
        public CompatC12PacketUpdateSign(CPacketUpdateSign packet) {
            super((Packet<? extends INetHandler>)packet);
        }

        public static CompatC12PacketUpdateSign create(CompatBlockPos pos, List<CompatChat.CompatTextComponent> clines) {
            List lines = Lists.transform(clines, input -> input == null ? null : input.component);
            return new CompatC12PacketUpdateSign(new CPacketUpdateSign(pos.pos, lines.toArray(new ITextComponent[lines.size()])));
        }
    }

    public static class CompatPacket {
        public final Packet<? extends INetHandler> packet;

        public CompatPacket(Packet<? extends INetHandler> packet) {
            this.packet = packet;
        }
    }

    public static class CompatNetHandlerPlayClient {
        private final NetHandlerPlayClient connection;

        public CompatNetHandlerPlayClient(NetHandlerPlayClient connection) {
            this.connection = connection;
        }

        public void sendPacket(CompatPacket packet) {
            this.connection.func_147297_a(packet.packet);
        }
    }

    public static class CompatMessage {
        public final IMessage message;

        public CompatMessage(IMessage message) {
            this.message = message;
        }

        public CompatMessage(Object message) {
            this((IMessage)message);
        }
    }

    public static class CompatSimpleNetworkWrapper {
        private final SimpleNetworkWrapper network;

        public CompatSimpleNetworkWrapper(SimpleNetworkWrapper network) {
            this.network = network;
        }

        public CompatSimpleNetworkWrapper(Object network) {
            this((SimpleNetworkWrapper)network);
        }

        public void sendToServer(CompatMessage message) {
            this.network.sendToServer(message.message);
        }
    }

    public static class CompatItems {
        public static final Item SIGN = Items.field_151155_ap;
    }

    public static class CompatBlocks {
        public static final Block STANDING_SIGN = Blocks.field_150472_an;
        public static final Block WALL_SIGN = Blocks.field_150444_as;
    }

    public static class CompatBlock {
        private final Block block;

        public CompatBlock(Block block) {
            this.block = block;
        }

        public Block getBlockObj() {
            return this.block;
        }

        public boolean canPlaceBlockAt(CompatWorld world, CompatBlockPos pos) {
            return this.block.func_176196_c(world.getWorldObj(), pos.pos);
        }
    }

    public static class CompatBlockState {
        private final IBlockState blockstate;

        public CompatBlockState(IBlockState blockstate) {
            this.blockstate = blockstate;
        }

        public IBlockState getBlockStateObj() {
            return this.blockstate;
        }

        public CompatBlock getBlock() {
            return new CompatBlock(this.blockstate.func_177230_c());
        }

        public Material getMaterial() {
            return this.blockstate.func_185904_a();
        }
    }

    public static class CompatWorld {
        private final World world;

        public CompatWorld(@Nonnull World world) {
            this.world = world;
        }

        public World getWorldObj() {
            return this.world;
        }

        public int getLightFor(CompatBlockPos pos) {
            return this.world.func_175642_b(EnumSkyBlock.SKY, pos.pos);
        }

        public CompatBlockState getBlockState(CompatBlockPos pos) {
            return new CompatBlockState(this.world.func_180495_p(pos.pos));
        }

        @Nullable
        public TileEntity getTileEntity(CompatBlockPos pos) {
            return this.world.func_175625_s(pos.pos);
        }
    }

    public static class CompatEntityPlayer {
        private final EntityPlayer player;

        public CompatEntityPlayer(@Nonnull EntityPlayer player) {
            this.player = player;
        }

        public EntityPlayer getPlayerObj() {
            return this.player;
        }

        @Nullable
        public ItemStack getHeldItemMainhand() {
            return this.player.func_184614_ca();
        }

        @Nullable
        public ItemStack getHeldItemOffhand() {
            return this.player.func_184592_cb();
        }
    }

    public static class CompatTileEntityRendererDispatcher {
        public static void renderTileEntityAt(@Nullable TileEntitySign tile, double x, double y, double z, float partialTicks, int destroy, float alpha) {
            TileEntityRendererDispatcher.field_147556_a.func_178469_a((TileEntity)tile, x, y, z, partialTicks, destroy);
        }
    }

    public static abstract class CompatTileEntitySignRenderer
    extends TileEntitySignRenderer {
        public void renderBaseTileEntityAt(@Nullable TileEntitySign tile, double x, double y, double z, float partialTicks, int destroy, float alpha) {
            super.func_180535_a(tile, x, y, z, partialTicks, destroy);
        }

        public abstract void renderTileEntityAtCompat(@Nullable TileEntitySign var1, double var2, double var4, double var6, float var8, int var9, float var10);

        public void func_180535_a(@Nullable TileEntitySign tile, double x, double y, double z, float partialTicks, int destroy) {
            this.renderTileEntityAtCompat(tile, x, y, z, partialTicks, destroy, 1.0f);
        }
    }

    public static class CompatKeyRegistrar {
        public static void registerKeyBinding(KeyBinding key) {
            ClientRegistry.registerKeyBinding((KeyBinding)key);
        }
    }

    public static class CompatBlockPos {
        @Nonnull
        public final BlockPos pos;

        public CompatBlockPos(@Nonnull BlockPos pos) {
            Validate.notNull((Object)pos, (String)"MovePos needs position", (Object[])new Object[0]);
            this.pos = pos;
        }

        public int getX() {
            return this.pos.func_177958_n();
        }

        public int getY() {
            return this.pos.func_177956_o();
        }

        public int getZ() {
            return this.pos.func_177952_p();
        }

        @Nonnull
        public CompatBlockPos offset(CompatEnumFacing facing) {
            if (facing == null) {
                return this;
            }
            return CompatBlockPos.fromCoords(this.getX() + facing.offsetX, this.getY() + facing.offsetY, this.getZ() + facing.offsetZ);
        }

        @Nonnull
        public static CompatBlockPos fromCoords(int xCoord, int yCoord, int zCoord) {
            return new CompatBlockPos(new BlockPos(xCoord, yCoord, zCoord));
        }

        @Nonnull
        public static CompatBlockPos getTileEntityPos(@Nonnull TileEntity tile) {
            return new CompatBlockPos(tile.func_174877_v());
        }

        public void setTileEntityPos(@Nonnull TileEntity tile) {
            tile.func_174878_a(this.pos);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.pos.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CompatBlockPos)) {
                return false;
            }
            CompatBlockPos other = (CompatBlockPos)obj;
            return this.pos.equals((Object)other.pos);
        }
    }
}

