/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureManager;
import net.teamfruit.emojicord.EmojicordConfig;
import net.teamfruit.emojicord.EmojicordScope;
import net.teamfruit.emojicord.compat.Compat;
import net.teamfruit.emojicord.compat.CompatBaseVertex;
import net.teamfruit.emojicord.compat.CompatVertex;
import net.teamfruit.emojicord.compat.OpenGL;
import net.teamfruit.emojicord.emoji.EmojiContext;
import net.teamfruit.emojicord.emoji.EmojiId;
import net.teamfruit.emojicord.emoji.EmojiObject;
import net.teamfruit.emojicord.emoji.EmojiText;

public class EmojiFontRenderer {
    public static boolean shadow;
    public static int index;
    private static EmojiContext CurrentContext;

    public static String updateEmojiContext(String text) {
        if (EmojicordConfig.spec.isAvailable() && EmojicordConfig.RENDER.renderEnabled.get().booleanValue()) {
            EnumSet<EmojiContext.EmojiContextAttribute> attributes = EnumSet.noneOf(EmojiContext.EmojiContextAttribute.class);
            StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
            if (EmojicordScope.instance.checkIsInput(stacks)) {
                attributes.add(EmojiContext.EmojiContextAttribute.CHAT_INPUT);
            }
            if (EmojicordScope.instance.checkIsMessage(stacks)) {
                attributes.add(EmojiContext.EmojiContextAttribute.CHAT_MESSAGE);
            }
            CurrentContext = EmojiContext.EmojiContextCache.instance.getContext(text, attributes);
            return EmojiFontRenderer.CurrentContext.text;
        }
        CurrentContext = null;
        return text;
    }

    public static boolean renderEmojiChar(char c, boolean italic, float x, float y, float red, float green, float blue, float alpha) {
        EmojiId emojiId;
        EmojiText.EmojiTextElement emojiElement;
        if (CurrentContext != null && (emojiElement = EmojiFontRenderer.CurrentContext.emojis.get(index)) != null && (emojiId = emojiElement.id) != null) {
            EmojiObject emoji = EmojiObject.EmojiObjectCache.instance.getEmojiObject(emojiId);
            if (!shadow) {
                Compat.CompatMinecraft.getMinecraft().getTextureManager().func_110577_a(emoji.loadAndGetResourceLocation());
                EmojiFontRenderer.renderEmoji(emoji, x, y, red, green, blue, alpha);
            }
            return c == '\u0000';
        }
        return false;
    }

    @Nullable
    public static EmojiGlyph getEmojiGlyph(char c, int index) {
        EmojiId emojiId;
        EmojiText.EmojiTextElement emojiElement;
        if (CurrentContext != null && (emojiElement = EmojiFontRenderer.CurrentContext.emojis.get(index)) != null && (emojiId = emojiElement.id) != null) {
            return new EmojiGlyph(emojiId);
        }
        return null;
    }

    public static void renderEmoji(EmojiObject emoji, float x, float y, float red, float green, float blue, float alpha) {
        float textureSize = 16.0f;
        float textureX = 0.0f;
        float textureY = 0.0f;
        float textureOffset = 1.0f;
        float size = 10.0f;
        float offsetY = 1.0f;
        float offsetX = 0.0f;
        OpenGL.glPushAttrib();
        int rgba = OpenGL.glGetColorRGBA();
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, (float)(OpenGL.glGetColorRGBA() >> 24 & 0xFF) / 256.0f);
        CompatBaseVertex bufferbuilder = CompatVertex.getTessellator();
        bufferbuilder.beginTexture(7);
        bufferbuilder.pos(x - 0.0f, y - 1.0f, 0.0).tex(0.0, 0.0);
        bufferbuilder.pos(x - 0.0f, y + 10.0f - 1.0f, 0.0).tex(0.0, 1.0);
        bufferbuilder.pos(x - 0.0f + 10.0f, y + 10.0f - 1.0f, 0.0).tex(1.0, 1.0);
        bufferbuilder.pos(x - 0.0f + 10.0f, y - 1.0f, 0.0).tex(1.0, 0.0);
        bufferbuilder.draw();
        OpenGL.glColorRGBA(rgba);
        OpenGL.glPopAttrib();
    }

    public static class EmojiTexturedGlyph
    extends Compat.CompatTexturedGlyph {
        public EmojiTexturedGlyph(EmojiId emojiId) {
            super(EmojiObject.EmojiObjectCache.instance.getEmojiObject(emojiId).loadAndGetResourceLocation(), 10.0f, 10.0f);
        }

        @Override
        public void onRender(TextureManager textureManager, boolean hasShadow, float x, float y, Compat.CompatBufferBuilder vbuilder, float red, float green, float blue, float alpha) {
            if (!shadow) {
                super.onRender(textureManager, hasShadow, x, y, vbuilder, 1.0f, 1.0f, 1.0f, alpha);
            }
        }
    }

    public static class EmojiGlyph
    extends Compat.CompatGlyph {
        public static final float GlyphWidth = 10.0f;
        public static final float GlyphHeight = 10.0f;
        private final EmojiId emojiId;

        public EmojiGlyph(EmojiId emojiId) {
            super(10.0f, 10.0f);
            this.emojiId = emojiId;
        }

        public EmojiTexturedGlyph getTexturedGlyph() {
            return new EmojiTexturedGlyph(this.emojiId);
        }
    }
}

