/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.madgag.gif.fmsware.GifDecoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.util.ResourceLocation;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.compat.Compat;
import net.teamfruit.emojicord.emoji.EmojiId;
import net.teamfruit.emojicord.util.Downloader;
import net.teamfruit.emojicord.util.Timer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class EmojiObject {
    public static final ResourceLocation loading_texture = new ResourceLocation("emojicord", "textures/26a0.png");
    public static final ResourceLocation error_texture = new ResourceLocation("emojicord", "textures/26d4.png");
    @Nonnull
    private static final ExecutorService threadpool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("emojicord-emoji-%d").setDaemon(true).build());
    private final EmojiId id;
    private boolean deleteOldTexture;
    private SimpleTexture img;
    private ResourceLocation resourceLocation = loading_texture;

    public EmojiObject(EmojiId id) {
        this.id = id;
    }

    private void checkLoad() {
        if (this.img == null) {
            this.img = new DownloadImageData(this.id.getCache(), this.id.getRemote(), loading_texture);
            this.resourceLocation = this.id.getResourceLocation();
            Compat.CompatMinecraft.getMinecraft().getTextureManager().func_110579_a(this.resourceLocation, (ITextureObject)this.img);
        }
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public ResourceLocation loadAndGetResourceLocation() {
        this.checkLoad();
        if (this.deleteOldTexture) {
            this.img.func_147631_c();
            this.deleteOldTexture = false;
        }
        return this.resourceLocation;
    }

    public void delete() {
        if (this.img != null) {
            this.img.func_147631_c();
            this.deleteOldTexture = false;
        }
    }

    public static class EmojiObjectCache {
        public static final long EMOJI_LIFETIME_SEC = 60L;
        public static final EmojiObjectCache instance = new EmojiObjectCache();
        private final LoadingCache<EmojiId, EmojiObject> EMOJI_ID_MAP = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).removalListener(notification -> {
            EmojiObject nvalue = (EmojiObject)notification.getValue();
            if (nvalue != null) {
                nvalue.delete();
            }
        }).build((CacheLoader)new CacheLoader<EmojiId, EmojiObject>(){

            public EmojiObject load(EmojiId key) throws Exception {
                return new EmojiObject(key);
            }
        });

        private EmojiObjectCache() {
        }

        @Nonnull
        public EmojiObject getEmojiObject(@Nonnull EmojiId name) {
            return (EmojiObject)this.EMOJI_ID_MAP.getUnchecked((Object)name);
        }
    }

    public class DownloadImageData
    extends Compat.CompatSimpleTexture {
        private final File cacheFile;
        private final String imageUrl;
        private final ResourceLocation textureResourceLocation;
        private CompletableFuture<byte[]> downloading;
        private boolean textureUploaded;
        private byte[] rawData;
        private BufferedImage imageData;
        private List<Pair<Integer, BufferedImage>> animationData;
        private final Compat.CompatTexture texture;
        private List<Pair<Integer, Compat.CompatTexture>> animation;
        private Timer timer;
        private Iterator<Pair<Integer, Compat.CompatTexture>> animationIterator;
        private Pair<Integer, Compat.CompatTexture> current;

        public DownloadImageData(File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation) {
            super(textureResourceLocation);
            this.timer = new Timer();
            this.cacheFile = cacheFileIn;
            this.imageUrl = imageUrlIn;
            this.textureResourceLocation = textureResourceLocation;
            this.texture = Compat.CompatTexture.getTexture(this);
        }

        private void checkTextureUploaded() {
            if (!this.textureUploaded) {
                if (this.imageData != null && this.animationData != null) {
                    if (this.field_110568_b != null) {
                        this.func_147631_c();
                    }
                    try {
                        this.texture.uploadTexture(this.imageData);
                        this.animation = this.animationData.stream().map(e -> {
                            Compat.CompatTexture t = Compat.CompatTexture.getTexture(new Compat.CompatSimpleTexture(this.textureResourceLocation));
                            try {
                                t.uploadTexture((BufferedImage)e.getRight());
                            }
                            catch (IOException e1) {
                                throw new UncheckedIOException(e1);
                            }
                            return Pair.of((Object)e.getLeft(), (Object)t);
                        }).collect(Collectors.toList());
                        this.animationIterator = new InfinityIterator<Pair<Integer, Compat.CompatTexture>>(this.animation);
                    }
                    catch (IOException | UncheckedIOException e2) {
                        Log.log.warn("Failed to load texture: ", (Throwable)e2);
                    }
                    this.imageData = null;
                    this.animationData = null;
                    this.textureUploaded = true;
                } else if (this.rawData != null) {
                    if (this.field_110568_b != null) {
                        this.func_147631_c();
                    }
                    try {
                        this.texture.uploadTexture(new ByteArrayInputStream(this.rawData));
                    }
                    catch (IOException e3) {
                        Log.log.warn("Failed to load texture: ", (Throwable)e3);
                    }
                    this.rawData = null;
                    this.textureUploaded = true;
                }
            }
        }

        public int func_110552_b() {
            this.checkTextureUploaded();
            if (this.animationIterator != null && this.animationIterator.hasNext()) {
                if (this.current == null) {
                    this.current = this.animationIterator.next();
                }
                Timer.tick();
                int currentId = ((Compat.CompatTexture)this.current.getRight()).getTextureObj().getRawGlTextureId();
                float t = this.timer.getTime() - (float)((Integer)this.current.getLeft()).intValue() / 1000.0f;
                if (t > 0.0f) {
                    this.current = null;
                    this.timer.set(t);
                }
                return currentId;
            }
            return super.getRawGlTextureId();
        }

        @Override
        public void loadTexture(Compat.CompatResourceManager resourceManager) throws IOException {
            if (this.textureUploaded) {
                return;
            }
            if (this.field_110568_b != null) {
                super.loadTexture(resourceManager);
            }
            if (this.downloading == null) {
                CompletionStage<Object> dataFuture;
                if (this.cacheFile == null) {
                    dataFuture = CompletableFuture.completedFuture(null);
                } else {
                    CompletableFuture<File> cacheFuture = this.cacheFile.isFile() ? CompletableFuture.completedFuture(this.cacheFile) : CompletableFuture.supplyAsync(this.downloadTextureFromServer(this.cacheFile), threadpool);
                    dataFuture = cacheFuture.thenApplyAsync(cacheFile -> {
                        try {
                            return IOUtils.toByteArray((InputStream)FileUtils.openInputStream((File)cacheFile));
                        }
                        catch (IOException ioexception) {
                            throw new UncheckedIOException(ioexception);
                        }
                    }, (Executor)threadpool);
                }
                CompletionStage statusFuture = dataFuture.exceptionally(e -> {
                    Log.log.warn("Failed to load texture: ", e);
                    return null;
                });
                ((CompletableFuture)statusFuture).thenAcceptAsync(data -> {
                    if (data == null) {
                        EmojiObject.this.resourceLocation = error_texture;
                        EmojiObject.this.deleteOldTexture = true;
                    } else {
                        GifDecoder d = new GifDecoder();
                        if (d.read(new ByteArrayInputStream((byte[])data)) == 0) {
                            this.imageData = d.getImage();
                            this.animationData = IntStream.range(0, d.getFrameCount()).mapToObj(i -> Pair.of((Object)d.getDelay(i), (Object)d.getFrame(i))).collect(Collectors.toList());
                        } else {
                            this.rawData = data;
                        }
                    }
                }, (Executor)threadpool);
            }
        }

        protected Supplier<File> downloadTextureFromServer(File cacheFile) {
            return () -> {
                File file;
                CloseableHttpResponse response = null;
                try {
                    HttpGet req = new HttpGet(this.imageUrl);
                    req.setHeaders(new Header[]{new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.80 Safari/537.36"), new BasicHeader("Accept", "*/*"), new BasicHeader("Accept-Encoding", ""), new BasicHeader("Accept-Language", "ja,en-US;q=0.9,en;q=0.8")});
                    HttpClientContext context = HttpClientContext.create();
                    response = Downloader.downloader.client.execute((HttpUriRequest)req, (HttpContext)context);
                    HttpEntity entity = response.getEntity();
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        throw new IOException("Invalid Status Code: " + statusCode);
                    }
                    FileUtils.copyInputStreamToFile((InputStream)entity.getContent(), (File)this.cacheFile);
                    file = cacheFile;
                }
                catch (IOException exception) {
                    try {
                        throw new UncheckedIOException(exception);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(response);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)response);
                return file;
            };
        }
    }

    public static class InfinityIterator<T>
    implements Iterator<T> {
        private final Iterable<T> iterable;
        private Iterator<T> iterator;

        public InfinityIterator(Iterable<T> iterable) {
            this.iterable = iterable;
            this.iterator = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            T next = this.iterator.next();
            if (!this.iterator.hasNext()) {
                this.iterator = this.iterable.iterator();
            }
            return next;
        }
    }
}

