/*
 * Decompiled with CFR 0.152.
 */
package io.github.seanboyy.enchantmentsreloaded.inventory.container;

import io.github.seanboyy.enchantmentsreloaded.objects.tileentity.CursebreakerTileEntity;
import io.github.seanboyy.enchantmentsreloaded.registers.Blocks;
import io.github.seanboyy.enchantmentsreloaded.registers.Containers;
import io.github.seanboyy.enchantmentsreloaded.util.Config;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CursebreakerContainer
extends Container {
    private final IInventory tableInventory = new Inventory(2){

        public void func_70296_d() {
            super.func_70296_d();
            CursebreakerContainer.this.func_75130_a((IInventory)this);
        }
    };
    private final IWorldPosCallable worldPosCallable;

    public CursebreakerContainer(int id, PlayerInventory playerInventoryIn, @Nonnull CursebreakerTileEntity cursebreakerTileEntity) {
        this(id, playerInventoryIn, IWorldPosCallable.func_221488_a((World)cursebreakerTileEntity.func_145831_w(), (BlockPos)cursebreakerTileEntity.func_174877_v()));
    }

    public CursebreakerContainer(int id, PlayerInventory playerInventoryIn, IWorldPosCallable worldPosCallable) {
        super((ContainerType)Containers.CURSEBREAKER.get(), id);
        this.worldPosCallable = worldPosCallable;
        this.func_75146_a(new Slot(this.tableInventory, 0, 15, 47){

            public boolean func_75214_a(ItemStack stack) {
                return true;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.tableInventory, 1, 35, 47){

            public boolean func_75214_a(ItemStack stack) {
                return Tags.Items.NETHER_STARS.func_199685_a_((Object)stack.func_77973_b());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, k, 8 + k * 18, 142));
        }
    }

    public CursebreakerContainer(int id, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(id, playerInventory, IWorldPosCallable.func_221488_a((World)playerInventory.field_70458_d.field_70170_p, (BlockPos)playerInventory.field_70458_d.func_180425_c()));
    }

    public boolean removeCurses(PlayerEntity playerIn) {
        ItemStack fuel;
        ItemStack cursedItem = this.tableInventory.func_70301_a(0);
        int curseCount = 0;
        if (!cursedItem.func_190926_b() && !cursedItem.func_77986_q().isEmpty()) {
            Map cursedItemEnchantments = EnchantmentHelper.func_82781_a((ItemStack)cursedItem);
            curseCount = (int)cursedItemEnchantments.keySet().stream().filter(Enchantment::func_190936_d).count();
        }
        if (((fuel = this.tableInventory.func_70301_a(1)).func_190926_b() || fuel.func_190916_E() < 1) && !playerIn.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (cursedItem.func_190926_b() || curseCount <= 0 || (float)cursedItem.func_77952_i() > (float)(cursedItem.func_77958_k() * curseCount) * Config.curse_removal_durability_factor && !playerIn.field_71075_bZ.field_75098_d) {
            return false;
        }
        int finalCurseCount = curseCount;
        this.worldPosCallable.func_221486_a((world, pos) -> {
            Map changedEnchantments = EnchantmentHelper.func_82781_a((ItemStack)cursedItem);
            EnchantmentHelper.func_82781_a((ItemStack)cursedItem).forEach((enchantment, level) -> {
                if (enchantment.func_190936_d()) {
                    changedEnchantments.remove(enchantment);
                }
            });
            ItemStack decursedItem = new ItemStack((IItemProvider)cursedItem.func_77973_b(), cursedItem.func_190916_E());
            EnchantmentHelper.func_82782_a((Map)changedEnchantments, (ItemStack)decursedItem);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                float newDamage = (float)cursedItem.func_77958_k() * Config.curse_removal_durability_factor * (float)finalCurseCount;
                int damageChangeResult = Config.curse_removal_durability_rounding_style ? MathHelper.func_76123_f((float)newDamage) : MathHelper.func_76141_d((float)newDamage);
                decursedItem.func_196085_b(damageChangeResult);
                fuel.func_190918_g(1);
                if (fuel.func_190926_b()) {
                    this.tableInventory.func_70299_a(1, ItemStack.field_190927_a);
                }
            } else {
                decursedItem.func_196085_b(cursedItem.func_77952_i());
            }
            this.tableInventory.func_70299_a(0, decursedItem);
            this.tableInventory.func_70296_d();
            this.func_75130_a(this.tableInventory);
            world.func_184133_a(null, pos, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        });
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerIn, playerIn.field_70170_p, this.tableInventory));
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return CursebreakerContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)Blocks.CURSEBREAKER.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 2) {
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (itemstack1.func_77973_b() == Items.field_151156_bN) {
                if (!this.func_75135_a(itemstack1, 1, 2, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (((Slot)this.field_75151_b.get(0)).func_75216_d() || !((Slot)this.field_75151_b.get(0)).func_75214_a(itemstack1)) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_77942_o()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(itemstack1.func_77979_a(1));
                } else if (!itemstack1.func_190926_b()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(new ItemStack((IItemProvider)itemstack1.func_77973_b()));
                    itemstack1.func_190918_g(1);
                }
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }
}

