/*
 * Decompiled with CFR 0.152.
 */
package io.github.seanboyy.enchantmentsreloaded.inventory.container;

import io.github.seanboyy.enchantmentsreloaded.EnchantmentsReloaded;
import io.github.seanboyy.enchantmentsreloaded.objects.tileentity.EnchantmentCraftingTableTileEntity;
import io.github.seanboyy.enchantmentsreloaded.registers.Blocks;
import io.github.seanboyy.enchantmentsreloaded.registers.Containers;
import io.github.seanboyy.enchantmentsreloaded.registers.Items;
import io.github.seanboyy.enchantmentsreloaded.util.EnchantmentModifierType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnchantmentCraftingTableContainer
extends Container {
    private final Random randomizer = new Random();
    private final IInventory tableInventory = new Inventory(2){

        public void func_70296_d() {
            super.func_70296_d();
            EnchantmentCraftingTableContainer.this.func_75130_a((IInventory)this);
        }
    };
    private final IWorldPosCallable worldPosCallable;

    public EnchantmentCraftingTableContainer(int id, PlayerInventory playerInventoryIn, @Nonnull EnchantmentCraftingTableTileEntity enchantmentCraftingTableTileEntity) {
        this(id, playerInventoryIn, IWorldPosCallable.func_221488_a((World)enchantmentCraftingTableTileEntity.func_145831_w(), (BlockPos)enchantmentCraftingTableTileEntity.func_174877_v()));
    }

    public EnchantmentCraftingTableContainer(int id, PlayerInventory playerInventoryIn, IWorldPosCallable worldPosCallable) {
        super((ContainerType)Containers.ENCHANTMENT_CRAFTING_TABLE.get(), id);
        this.worldPosCallable = worldPosCallable;
        this.func_75146_a(new Slot(this.tableInventory, 0, 70, 20){

            public boolean func_75214_a(ItemStack stack) {
                return true;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.tableInventory, 1, 90, 20){

            public boolean func_75214_a(ItemStack stack) {
                return EnchantmentsReloaded.Tags.ENCHANTMENT_MODIFIERS.func_199685_a_((Object)stack.func_77973_b());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, k, 8 + k * 18, 142));
        }
    }

    public EnchantmentCraftingTableContainer(int id, PlayerInventory playerInventoryIn, PacketBuffer data) {
        this(id, playerInventoryIn, IWorldPosCallable.func_221488_a((World)playerInventoryIn.field_70458_d.field_70170_p, (BlockPos)playerInventoryIn.field_70458_d.func_180425_c()));
    }

    public EnchantmentModifierType getModifierType() {
        ItemStack modifierItem = this.tableInventory.func_70301_a(1);
        if (!modifierItem.func_190926_b()) {
            if (modifierItem.func_77973_b() == Items.RANDOMIZER.get()) {
                return EnchantmentModifierType.RANDOMIZE;
            }
            if (modifierItem.func_77973_b() == Items.DISENCHANTER.get()) {
                return EnchantmentModifierType.SUBTRACT;
            }
            if (modifierItem.func_77973_b() == Items.ENCHANTER.get()) {
                return EnchantmentModifierType.ADD;
            }
            if (modifierItem.func_77973_b() == Items.LEVELER.get()) {
                return EnchantmentModifierType.LEVEL;
            }
        }
        return EnchantmentModifierType.NONE;
    }

    public static boolean enchantmentCanApplyAgainstCollection(Collection<Enchantment> enchantments, Enchantment enchantment) {
        for (Enchantment ench : enchantments) {
            if (enchantment.func_77326_a(ench)) continue;
            return false;
        }
        return true;
    }

    public boolean performModification(PlayerEntity playerIn, EnchantmentModifierType modifierTypeIn) {
        ItemStack enchantedItem = this.tableInventory.func_70301_a(0);
        ItemStack fuel = this.tableInventory.func_70301_a(1);
        Map enchantmentsOnItem = EnchantmentHelper.func_82781_a((ItemStack)enchantedItem);
        if (enchantmentsOnItem.isEmpty() || (fuel.func_190926_b() || fuel.func_190916_E() < 1) && !playerIn.field_71075_bZ.field_75098_d) {
            return false;
        }
        this.worldPosCallable.func_221486_a((world, pos) -> {
            ArrayList enchantments = new ArrayList();
            switch (modifierTypeIn) {
                case ADD: {
                    ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(enchantment -> enchantment.func_92089_a(enchantedItem)).filter(enchantment -> EnchantmentCraftingTableContainer.enchantmentCanApplyAgainstCollection(enchantmentsOnItem.keySet(), enchantment)).forEach(enchantments::add);
                    if (enchantments.size() <= 0) break;
                    int randomEnchantment = this.randomizer.nextInt(enchantments.size());
                    int randomLevel = MathHelper.func_76125_a((int)this.randomizer.nextInt(((Enchantment)enchantments.get(randomEnchantment)).func_77325_b() + 1), (int)((Enchantment)enchantments.get(randomEnchantment)).func_77319_d(), (int)((Enchantment)enchantments.get(randomEnchantment)).func_77325_b());
                    enchantmentsOnItem.put(enchantments.get(randomEnchantment), randomLevel);
                    break;
                }
                case SUBTRACT: {
                    int rand = this.randomizer.nextInt(enchantmentsOnItem.size());
                    ArrayList orderedListEnchantmentsOnItem = new ArrayList(enchantmentsOnItem.keySet());
                    if (orderedListEnchantmentsOnItem.size() > 1) {
                        while (((Enchantment)orderedListEnchantmentsOnItem.get(rand)).func_190936_d()) {
                            rand = this.randomizer.nextInt(enchantmentsOnItem.size());
                        }
                        enchantmentsOnItem.remove(orderedListEnchantmentsOnItem.get(rand));
                        break;
                    }
                    if (((Enchantment)orderedListEnchantmentsOnItem.get(0)).func_190936_d()) break;
                    enchantmentsOnItem.clear();
                    break;
                }
                case RANDOMIZE: {
                    int i;
                    ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(enchantment -> enchantment.func_92089_a(enchantedItem)).forEach(enchantments::add);
                    enchantmentsOnItem.clear();
                    if (enchantments.size() <= 0) break;
                    int randomEnchantmentCount = MathHelper.func_76125_a((int)this.randomizer.nextInt(enchantments.size()), (int)1, (int)(this.randomizer.nextFloat() < 0.2f ? enchantments.size() : 3));
                    ArrayList<Integer> numbers = new ArrayList<Integer>();
                    for (int i2 = 0; i2 < enchantments.size(); ++i2) {
                        numbers.add(i2);
                    }
                    Collections.shuffle(numbers);
                    ArrayList<Enchantment> proposedEnchantments = new ArrayList<Enchantment>();
                    ArrayList<Integer> proposedLevels = new ArrayList<Integer>();
                    for (i = 0; i < randomEnchantmentCount; ++i) {
                        Enchantment proposedEnchantment = (Enchantment)enchantments.get((Integer)numbers.get(i));
                        if (!EnchantmentCraftingTableContainer.enchantmentCanApplyAgainstCollection(proposedEnchantments, proposedEnchantment)) continue;
                        proposedEnchantments.add(proposedEnchantment);
                        proposedLevels.add(MathHelper.func_76125_a((int)this.randomizer.nextInt(proposedEnchantment.func_77325_b() + 1), (int)1, (int)proposedEnchantment.func_77325_b()));
                    }
                    for (i = 0; i < proposedEnchantments.size(); ++i) {
                        enchantmentsOnItem.put(proposedEnchantments.get(i), proposedLevels.get(i));
                    }
                    break;
                }
                case LEVEL: {
                    ArrayList levelableEnchantmentsOnItem = new ArrayList();
                    enchantmentsOnItem.forEach((enchantment, level) -> {
                        if (level < enchantment.func_77325_b()) {
                            levelableEnchantmentsOnItem.add(Pair.of((Object)enchantment, (Object)level));
                        }
                    });
                    if (levelableEnchantmentsOnItem.isEmpty()) break;
                    int randomEnchantmentToLevelUp = this.randomizer.nextInt(levelableEnchantmentsOnItem.size());
                    int randomAmountToLevelEnchantmentUpBy = this.randomizer.nextFloat() > 0.75f ? 2 : 1;
                    int newEnchantmentLevel = MathHelper.func_76125_a((int)((Integer)((Pair)levelableEnchantmentsOnItem.get(randomEnchantmentToLevelUp)).getRight() + randomAmountToLevelEnchantmentUpBy), (int)((Enchantment)((Pair)levelableEnchantmentsOnItem.get(randomEnchantmentToLevelUp)).getLeft()).func_77319_d(), (int)((Enchantment)((Pair)levelableEnchantmentsOnItem.get(randomEnchantmentToLevelUp)).getLeft()).func_77325_b());
                    Pair newEnchantmentWithNewLevel = Pair.of((Object)((Pair)levelableEnchantmentsOnItem.get(randomEnchantmentToLevelUp)).getLeft(), (Object)newEnchantmentLevel);
                    enchantmentsOnItem.remove(newEnchantmentWithNewLevel.getLeft());
                    enchantmentsOnItem.put(newEnchantmentWithNewLevel.getLeft(), newEnchantmentWithNewLevel.getRight());
                }
            }
            EnchantmentHelper.func_82782_a((Map)enchantmentsOnItem, (ItemStack)enchantedItem);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                fuel.func_190918_g(1);
                if (fuel.func_190926_b()) {
                    this.tableInventory.func_70299_a(1, ItemStack.field_190927_a);
                }
            }
            this.tableInventory.func_70299_a(0, enchantedItem);
            this.tableInventory.func_70296_d();
            this.func_75130_a(this.tableInventory);
            world.func_184133_a(null, pos, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        });
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerIn, playerIn.field_70170_p, this.tableInventory));
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return EnchantmentCraftingTableContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)Blocks.ENCHANTMENT_CRAFTING_TABLE.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 2) {
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (itemstack1.func_77973_b() == Items.RANDOMIZER.get() || itemstack1.func_77973_b() == Items.ENCHANTER.get() || itemstack1.func_77973_b() == Items.DISENCHANTER.get() || itemstack1.func_77973_b() == Items.LEVELER.get()) {
                if (!this.func_75135_a(itemstack1, 1, 2, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (((Slot)this.field_75151_b.get(0)).func_75216_d() || !((Slot)this.field_75151_b.get(0)).func_75214_a(itemstack1)) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_77942_o()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(itemstack1.func_77979_a(1));
                } else if (!itemstack1.func_190926_b()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(new ItemStack((IItemProvider)itemstack1.func_77973_b()));
                    itemstack1.func_190918_g(1);
                }
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }
}

