/*
 * Decompiled with CFR 0.152.
 */
package io.github.seanboyy.enchantmentsreloaded.inventory.container;

import io.github.seanboyy.enchantmentsreloaded.objects.blocks.TransferTableBlock;
import io.github.seanboyy.enchantmentsreloaded.registers.Blocks;
import io.github.seanboyy.enchantmentsreloaded.registers.Containers;
import io.github.seanboyy.enchantmentsreloaded.util.Config;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TransferTableContainer
extends Container {
    private final IInventory tableInventory = new Inventory(3){

        public void func_70296_d() {
            super.func_70296_d();
            TransferTableContainer.this.func_75130_a((IInventory)this);
        }
    };
    private final IWorldPosCallable worldPosCallable;

    public TransferTableContainer(int id, PlayerInventory playerInventoryIn, PacketBuffer packetBuffer) {
        this(id, playerInventoryIn, IWorldPosCallable.func_221488_a((World)playerInventoryIn.field_70458_d.field_70170_p, (BlockPos)playerInventoryIn.field_70458_d.func_180425_c()));
    }

    public TransferTableContainer(int id, PlayerInventory playerInventoryIn, IWorldPosCallable worldPosCallable) {
        super((ContainerType)Containers.TRANSFER_TABLE.get(), id);
        this.worldPosCallable = worldPosCallable;
        this.func_75146_a(new Slot(this.tableInventory, 0, 44, 17){

            public boolean func_75214_a(ItemStack stack) {
                return !stack.func_77986_q().isEmpty();
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.tableInventory, 1, 116, 17){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77986_q().isEmpty();
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.tableInventory, 2, 80, 29){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == Items.field_221659_bR;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, k, 8 + k * 18, 142));
        }
    }

    public boolean transferEnchantments(PlayerEntity playerIn) {
        ItemStack fuel;
        ItemStack source = this.tableInventory.func_70301_a(0);
        int sourceEnchantmentCount = 0;
        if (!source.func_190926_b() && !source.func_77986_q().isEmpty()) {
            sourceEnchantmentCount = EnchantmentHelper.func_82781_a((ItemStack)source).keySet().size();
        }
        ItemStack dest = this.tableInventory.func_70301_a(1);
        int destEnchantmentCount = 0;
        if (!source.func_190926_b() && !source.func_77986_q().isEmpty()) {
            destEnchantmentCount = EnchantmentHelper.func_82781_a((ItemStack)dest).keySet().size();
        }
        if (((fuel = this.tableInventory.func_70301_a(2)).func_190926_b() || fuel.func_190916_E() < 1) && !playerIn.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (source.func_190926_b() || sourceEnchantmentCount <= 0) {
            return false;
        }
        if (dest.func_190926_b() || destEnchantmentCount > 0) {
            return false;
        }
        Map enchantmentsOnSource = EnchantmentHelper.func_82781_a((ItemStack)source);
        this.worldPosCallable.func_221486_a((world, pos) -> {
            LinkedHashMap enchantmentsToPutOnDest = new LinkedHashMap();
            enchantmentsOnSource.forEach((enchantment, level) -> {
                if (enchantment.func_92089_a(dest)) {
                    enchantmentsToPutOnDest.put(enchantment, level);
                }
            });
            if (!playerIn.field_71075_bZ.field_75098_d) {
                Block block;
                fuel.func_190918_g(1);
                if (fuel.func_190926_b()) {
                    this.tableInventory.func_70299_a(2, ItemStack.field_190927_a);
                }
                if ((block = world.func_180495_p(pos).func_177230_c()) instanceof TransferTableBlock) {
                    ((TransferTableBlock)block).breakChance += Config.enchantment_transfer_use_break_chance;
                    if (playerIn.func_70681_au().nextFloat() < ((TransferTableBlock)block).breakChance) {
                        BlockState damageState = TransferTableBlock.damage(world.func_180495_p(pos));
                        if (damageState == null) {
                            world.func_217377_a(pos, false);
                            world.func_217379_c(1029, pos, 0);
                        } else {
                            world.func_180501_a(pos, damageState, 2);
                        }
                    }
                }
            }
            EnchantmentHelper.func_82782_a(enchantmentsToPutOnDest, (ItemStack)dest);
            this.tableInventory.func_70299_a(0, ItemStack.field_190927_a);
            this.tableInventory.func_70299_a(1, dest);
            this.tableInventory.func_70296_d();
            this.func_75130_a(this.tableInventory);
            world.func_184133_a(null, pos, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        });
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerIn, playerIn.field_70170_p, this.tableInventory));
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return TransferTableContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)Blocks.TRANSFER_TABLE.get())) || TransferTableContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)Blocks.TRANSFER_TABLE_CHIPPED.get())) || TransferTableContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)Blocks.TRANSFER_TABLE_DAMAGED.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 3) {
                if (!this.func_75135_a(itemstack1, 3, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (itemstack1.func_77973_b() == Items.field_221659_bR) {
                if (!this.func_75135_a(itemstack1, 2, 3, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!((Slot)this.field_75151_b.get(0)).func_75216_d() && ((Slot)this.field_75151_b.get(0)).func_75214_a(itemstack1)) {
                if (itemstack1.func_77942_o()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(itemstack1.func_77979_a(1));
                } else if (!itemstack1.func_190926_b()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(new ItemStack((IItemProvider)itemstack1.func_77973_b()));
                    itemstack1.func_190918_g(1);
                }
            } else if (!((Slot)this.field_75151_b.get(1)).func_75216_d() && ((Slot)this.field_75151_b.get(1)).func_75214_a(itemstack1)) {
                if (itemstack1.func_77942_o()) {
                    ((Slot)this.field_75151_b.get(1)).func_75215_d(itemstack1.func_77979_a(1));
                } else if (!itemstack1.func_190926_b()) {
                    ((Slot)this.field_75151_b.get(1)).func_75215_d(new ItemStack((IItemProvider)itemstack.func_77973_b()));
                    itemstack1.func_190918_g(1);
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }
}

