/*
 * Decompiled with CFR 0.152.
 */
package io.github.seanboyy.enchantmentsreloaded.network;

import io.github.seanboyy.enchantmentsreloaded.EnchantmentsReloaded;
import io.github.seanboyy.enchantmentsreloaded.network.PacketIdServer;
import io.github.seanboyy.enchantmentsreloaded.network.packet.IPacketHandler;
import io.github.seanboyy.enchantmentsreloaded.network.packet.PacketEnchantmentModifyRequest;
import io.github.seanboyy.enchantmentsreloaded.network.packet.PacketEnchantmentTransferRequest;
import io.github.seanboyy.enchantmentsreloaded.network.packet.PacketItemDecursedRequest;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketHandler {
    public static final ResourceLocation CHANNEL_ID = new ResourceLocation("enchantmentsreloaded", "channel");
    public final EnumMap<PacketIdServer, IPacketHandler> serverHandlers = new EnumMap(PacketIdServer.class);

    public PacketHandler() {
        this.serverHandlers.put(PacketIdServer.ITEM_DECURSE_REQUEST, PacketItemDecursedRequest::readPacketData);
        this.serverHandlers.put(PacketIdServer.ENCHANTMENT_MODIFY_REQUEST, PacketEnchantmentModifyRequest::readPacketData);
        this.serverHandlers.put(PacketIdServer.ENCHANTMENT_TRANSFERRED_REQUEST, PacketEnchantmentTransferRequest::readPacketData);
    }

    public void onPacket(NetworkEvent.ClientCustomPayloadEvent event) {
        PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)event.getPayload());
        NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            EnchantmentsReloaded.LOGGER.error("Packet error, the sending player is missing for event: {}", (Object)event);
            return;
        }
        try {
            byte packetIdOrdinal = packetBuffer.readByte();
            PacketIdServer packetId = PacketIdServer.VALUES[packetIdOrdinal];
            IPacketHandler packetHandler = this.serverHandlers.get(packetId);
            packetHandler.readPacketData(packetBuffer, (PlayerEntity)player);
        }
        catch (RuntimeException e) {
            EnchantmentsReloaded.LOGGER.error("Packet error for event: {}", (Object)event, (Object)e);
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }
}

