/*
 * Decompiled with CFR 0.152.
 */
package io.github.seanboyy.enchantmentsreloaded.network;

import io.github.seanboyy.enchantmentsreloaded.EnchantmentsReloaded;
import io.github.seanboyy.enchantmentsreloaded.network.PacketIdClient;
import io.github.seanboyy.enchantmentsreloaded.network.packet.IPacketHandler;
import io.github.seanboyy.enchantmentsreloaded.network.packet.PacketEnchantmentModified;
import io.github.seanboyy.enchantmentsreloaded.network.packet.PacketEnchantmentTransfer;
import io.github.seanboyy.enchantmentsreloaded.network.packet.PacketItemDecursed;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketHandlerClient {
    public final EnumMap<PacketIdClient, IPacketHandler> clientHandlers = new EnumMap(PacketIdClient.class);

    public PacketHandlerClient() {
        this.clientHandlers.put(PacketIdClient.ITEM_DECURSED, PacketItemDecursed::readPacketData);
        this.clientHandlers.put(PacketIdClient.ENCHANTMENT_MODIFIED, PacketEnchantmentModified::readPacketData);
        this.clientHandlers.put(PacketIdClient.ENCHANTMENT_TRANSFERRED, PacketEnchantmentTransfer::readPacketData);
    }

    public void onPacket(NetworkEvent.ServerCustomPayloadEvent event) {
        try {
            PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)event.getPayload());
            byte packetIdOrdinal = packetBuffer.readByte();
            PacketIdClient packetId = PacketIdClient.VALUES[packetIdOrdinal];
            IPacketHandler packetHandler = this.clientHandlers.get(packetId);
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientPlayerEntity clientPlayerEntity = minecraft.field_71439_g;
            if (clientPlayerEntity != null) {
                packetHandler.readPacketData(packetBuffer, (PlayerEntity)clientPlayerEntity);
            }
        }
        catch (Exception e) {
            EnchantmentsReloaded.LOGGER.error("Packet error", (Throwable)e);
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }
}

