/*
 * Decompiled with CFR 0.152.
 */
package io.github.seanboyy.enchantmentsreloaded.objects.blocks;

import io.github.seanboyy.enchantmentsreloaded.inventory.container.TransferTableContainer;
import io.github.seanboyy.enchantmentsreloaded.registers.Blocks;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TransferTableBlock
extends FallingBlock {
    public float breakChance = 0.0f;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape PART_BASE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape PART_LOWER_X = Block.func_208617_a((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0);
    private static final VoxelShape PART_MID_X = Block.func_208617_a((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape PART_UPPER_X = Block.func_208617_a((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape PART_LOWER_Z = Block.func_208617_a((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0);
    private static final VoxelShape PART_MID_Z = Block.func_208617_a((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape PART_UPPER_Z = Block.func_208617_a((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape X_AXIS_AABB = VoxelShapes.func_216384_a((VoxelShape)PART_BASE, (VoxelShape[])new VoxelShape[]{PART_LOWER_X, PART_MID_X, PART_UPPER_X});
    private static final VoxelShape Z_AXIS_AABB = VoxelShapes.func_216384_a((VoxelShape)PART_BASE, (VoxelShape[])new VoxelShape[]{PART_LOWER_Z, PART_MID_Z, PART_UPPER_Z});
    private static final TranslationTextComponent translationName = new TranslationTextComponent("enchantmentsreloaded.container.transfer_table", new Object[0]);

    public TransferTableBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        return direction.func_176740_k() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    protected void func_149829_a(FallingBlockEntity fallingEntity) {
        fallingEntity.func_145806_a(true);
    }

    public void func_176502_a_(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState) {
        worldIn.func_217379_c(1031, pos, 0);
    }

    public void func_190974_b(World worldIn, BlockPos pos) {
        worldIn.func_217379_c(1029, pos, 0);
    }

    @Nullable
    public static BlockState damage(BlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.TRANSFER_TABLE.get()) {
            return (BlockState)((Block)Blocks.TRANSFER_TABLE_CHIPPED.get()).func_176223_P().func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING));
        }
        return block == Blocks.TRANSFER_TABLE_CHIPPED.get() ? (BlockState)((Block)Blocks.TRANSFER_TABLE_DAMAGED.get()).func_176223_P().func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)) : null;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            player.func_213829_a(state.func_215699_b(worldIn, pos));
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return new SimpleNamedContainerProvider((id, playerInventoryIn, playerIn) -> new TransferTableContainer(id, playerInventoryIn, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos)), (ITextComponent)translationName);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

