/*
 * Decompiled with CFR 0.152.
 */
package io.github.seanboyy.enchantmentsreloaded.util;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static float curse_removal_durability_factor;
    public static boolean curse_removal_durability_rounding_style;
    public static float enchantment_transfer_use_break_chance;

    public static void bakeConfig() {
        curse_removal_durability_factor = ((Float)Config.CLIENT.CURSE_DURABILITY_FACTOR.get()).floatValue();
        curse_removal_durability_rounding_style = (Boolean)Config.CLIENT.CURSE_ROUNDING_STYLE.get();
        enchantment_transfer_use_break_chance = ((Float)Config.CLIENT.BREAK_CHANCE.get()).floatValue();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static final class ClientConfig {
        public final ForgeConfigSpec.ConfigValue<Float> CURSE_DURABILITY_FACTOR;
        public final ForgeConfigSpec.ConfigValue<Boolean> CURSE_ROUNDING_STYLE;
        public final ForgeConfigSpec.ConfigValue<Float> BREAK_CHANCE;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.CURSE_DURABILITY_FACTOR = builder.comment("What percent of durability should removing a curse use?").translation("enchantmentsreloaded.config.curse_durability_factor").define("curse_durability_factor", (Object)Float.valueOf(0.33333334f));
            this.CURSE_ROUNDING_STYLE = builder.comment("When decreasing durability from removing curses, should we round the result of multiplication up?").translation("enchantmentsreloaded.config.curse_durability_rounding_style").define("curse_durability_rounding_style", true);
            this.BREAK_CHANCE = builder.comment("When using the transfer table, what should the chance the block will break increase by per use? (Capped at 1)").translation("enchantmentsreloaded.config.transfer_use_break_chance").define("transfer_use_break_chance", (Object)Float.valueOf(0.02f));
        }
    }
}

