/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin;

import com.shultrea.rin.NewConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="enchantmentswitch")
public class EnchantmentSwitch {
    public EnchantmentSwitch() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, NewConfig.SPEC);
    }

    public void setEnchantments(Map<Enchantment, Integer> enchMap, ItemStack stack) {
        ListNBT listnbt = new ListNBT();
        for (Map.Entry<Enchantment, Integer> entry : enchMap.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("id", String.valueOf(ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)enchantment)));
            compoundnbt.func_74777_a("lvl", (short)i);
            listnbt.add((Object)compoundnbt);
            if (stack.func_77973_b() != Items.field_151134_bR) continue;
            EnchantedBookItem.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(enchantment, i));
        }
        if (listnbt.isEmpty()) {
            stack.func_196083_e("Enchantments");
        } else if (stack.func_77973_b() != Items.field_151134_bR) {
            stack.func_77983_a("Enchantments", (INBT)listnbt);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAnvilPotentials(AnvilUpdateEvent e) {
        if (e.getLeft().func_190926_b()) {
            return;
        }
        if (e.getRight().func_190926_b()) {
            return;
        }
        if (e.getLeft().getItemEnchantability() <= 0) {
            return;
        }
        if (e.getLeft().func_77985_e() || e.getLeft().func_77942_o()) {
            return;
        }
        boolean hasPotentials = false;
        ItemStack r = e.getRight();
        if (r.func_77973_b() == Items.field_151134_bR) {
            ListNBT nbt = EnchantedBookItem.func_92110_g((ItemStack)r);
            if (nbt.size() > 1) {
                return;
            }
            for (int x = 0; x < nbt.size(); ++x) {
                CompoundNBT n = nbt.func_150305_b(x);
                if (!n.func_74779_i("id").equals("nee:upgraded_potentials")) continue;
                hasPotentials = true;
                break;
            }
        }
        if (hasPotentials) {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAnvilEnchantment(AnvilUpdateEvent e) {
        if (e.getLeft().func_190926_b()) {
            return;
        }
        if (e.getRight().func_190926_b()) {
            return;
        }
        if (e.getLeft().getItemEnchantability() <= 0) {
            return;
        }
        if (!e.getRight().func_77948_v()) {
            return;
        }
        if (!e.getOutput().func_190926_b()) {
            return;
        }
        if (e.getLeft().func_77973_b() == Items.field_151134_bR) {
            return;
        }
        if (e.getLeft().func_77985_e()) {
            return;
        }
        if (!e.getLeft().func_77973_b().getClass().isInstance(e.getRight().func_77973_b()) && !e.getRight().func_77973_b().getClass().isInstance(e.getLeft().func_77973_b())) {
            return;
        }
        Map data = EnchantmentHelper.func_82781_a((ItemStack)e.getRight());
        Map left = EnchantmentHelper.func_82781_a((ItemStack)e.getLeft());
        HashMap<Enchantment, Integer> incompatibleCombined = new HashMap<Enchantment, Integer>();
        if (data.size() == 0) {
            return;
        }
        boolean reduceFinalCost = (Boolean)NewConfig.REDUCE_FINAL_COST_VIA_ENCHANTABILITY.get();
        int minimumLevelCost = (Integer)NewConfig.MIN_COST.get();
        int commonCost = (Integer)NewConfig.COMMON_COST.get();
        int uncommonCost = (Integer)NewConfig.UNCOMMON_COST.get();
        int rareCost = (Integer)NewConfig.RARE_COST.get();
        int veryRareCost = (Integer)NewConfig.VERY_RARE_COST.get();
        int tCommonCost = (Integer)NewConfig.COMMON_TREASURE_COST.get();
        int tUncommonCost = (Integer)NewConfig.UNCOMMON_TREASURE_COST.get();
        int tRareCost = (Integer)NewConfig.RARE_TREASURE_COST.get();
        int tVeryRareCost = (Integer)NewConfig.VERY_RARE_TREASURE_COST.get();
        ItemStack stack = e.getLeft().func_77946_l();
        int cost = 0;
        for (Map.Entry map : data.entrySet()) {
            boolean isTreasure = ((Enchantment)map.getKey()).func_185261_e();
            switch (((Enchantment)map.getKey()).func_77324_c()) {
                case COMMON: {
                    if (isTreasure) {
                        cost += (Integer)map.getValue() * tCommonCost;
                        break;
                    }
                    cost += (Integer)map.getValue() * commonCost;
                    break;
                }
                case UNCOMMON: {
                    if (isTreasure) {
                        cost += (Integer)map.getValue() * tUncommonCost;
                        break;
                    }
                    cost += (Integer)map.getValue() * uncommonCost;
                    break;
                }
                case RARE: {
                    if (isTreasure) {
                        cost += (Integer)map.getValue() * tRareCost;
                        break;
                    }
                    cost += (Integer)map.getValue() * rareCost;
                    break;
                }
                case VERY_RARE: {
                    if (isTreasure) {
                        cost += (Integer)map.getValue() * tVeryRareCost;
                        break;
                    }
                    cost += (Integer)map.getValue() * veryRareCost;
                }
            }
        }
        incompatibleCombined.putAll(left);
        Enchantment key = null;
        int val = -1;
        block7: for (Map.Entry each : data.entrySet()) {
            boolean isTheSameEnchantmentFound = false;
            key = null;
            val = -1;
            for (Map.Entry entri : left.entrySet()) {
                int secondVal;
                if (entri.getKey() != each.getKey()) {
                    if (((Enchantment)entri.getKey()).func_191560_c((Enchantment)each.getKey()) && ((Enchantment)each.getKey()).func_191560_c((Enchantment)entri.getKey())) continue;
                    isTheSameEnchantmentFound = false;
                    continue block7;
                }
                if (isTheSameEnchantmentFound) continue;
                isTheSameEnchantmentFound = true;
                int firstVal = (Integer)entri.getValue();
                if (firstVal == (secondVal = ((Integer)each.getValue()).intValue())) {
                    key = (Enchantment)entri.getKey();
                    val = Math.min(key.func_77325_b(), firstVal + 1);
                    continue;
                }
                key = (Enchantment)entri.getKey();
                val = Math.max(firstVal, secondVal);
            }
            if (isTheSameEnchantmentFound) {
                incompatibleCombined.put(key, val);
                continue;
            }
            incompatibleCombined.put((Enchantment)each.getKey(), (Integer)each.getValue());
        }
        this.setEnchantments(incompatibleCombined, stack);
        if (reduceFinalCost) {
            cost -= e.getLeft().getItemEnchantability();
        }
        e.setCost(Math.max(cost, Math.max(minimumLevelCost, 0)));
        e.setOutput(stack);
    }
}

