/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin;

import net.minecraftforge.common.ForgeConfigSpec;

public class NewConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.IntValue COMMON_COST;
    public static final ForgeConfigSpec.IntValue COMMON_TREASURE_COST;
    public static final ForgeConfigSpec.IntValue UNCOMMON_COST;
    public static final ForgeConfigSpec.IntValue UNCOMMON_TREASURE_COST;
    public static final ForgeConfigSpec.IntValue RARE_COST;
    public static final ForgeConfigSpec.IntValue RARE_TREASURE_COST;
    public static final ForgeConfigSpec.IntValue VERY_RARE_COST;
    public static final ForgeConfigSpec.IntValue VERY_RARE_TREASURE_COST;
    public static final ForgeConfigSpec.IntValue MIN_COST;
    public static final ForgeConfigSpec.BooleanValue REDUCE_FINAL_COST_VIA_ENCHANTABILITY;

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("For Enchantment Rarity Cost, Use the calculaton below for reference:\ntotal = (FOR EACH ENCHANTMENT ADDED -> enchantment rarity * enchantment level) - the output's item enchantability If total less than minimum level cost, then minimum level cost is the new total cost\nFor example, using default configurations, if mending is added to a wooden sword, the total is 5 since 7(RARE, TREASURE = 7 * 1(mending level) = 7) - 15(wooden sword's enchantability) = -8 but the minimum level cost is 5\n\n");
        COMMON_COST = builder.defineInRange("commonCost", 3, 0, Integer.MAX_VALUE);
        UNCOMMON_COST = builder.defineInRange("uncommonCost", 3, 0, Integer.MAX_VALUE);
        RARE_COST = builder.defineInRange("rareCost", 4, 0, Integer.MAX_VALUE);
        VERY_RARE_COST = builder.defineInRange("veryRareCost", 5, 0, Integer.MAX_VALUE);
        COMMON_TREASURE_COST = builder.defineInRange("commonTreasureCost", 5, 0, Integer.MAX_VALUE);
        UNCOMMON_TREASURE_COST = builder.defineInRange("uncommonTreasureCost", 6, 0, Integer.MAX_VALUE);
        RARE_TREASURE_COST = builder.defineInRange("rareTreasureCost", 7, 0, Integer.MAX_VALUE);
        VERY_RARE_TREASURE_COST = builder.defineInRange("veryRareTreasureCost", 8, 0, Integer.MAX_VALUE);
        MIN_COST = builder.comment("The minimum level cost per enchantment transferring").defineInRange("minimumLevelCost", 5, 0, Integer.MAX_VALUE);
        REDUCE_FINAL_COST_VIA_ENCHANTABILITY = builder.comment("This reduces the final cost by subtracting the final cost to the output's enchantability").define("reduceTotalCostViaItemEnchantability", true);
        SPEC = builder.build();
    }
}

