/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes;

import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.RecipeRoot;
import crazypants.enderio.config.recipes.StaxFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;

public class RecipeFactory {
    private static final String DEFAULT_USER_FILE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<enderio:recipes xmlns:enderio=\"http://enderio.com/recipes\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://enderio.com/recipes recipes.xsd \">\n\n</enderio:recipes>\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends RecipeRoot> T readFile(T target, String rootElement, String fileName) throws IOException, XMLStreamException {
        File configFile;
        RecipeRoot defaultConfig;
        InputStream defaultFileStream;
        FileInputStream userFileStream;
        block9: {
            RecipeRoot recipeRoot;
            RecipeFactory.copyCore("recipes.xsd");
            userFileStream = null;
            defaultFileStream = null;
            try {
                RecipeRoot userConfig = null;
                defaultConfig = null;
                RecipeFactory.copyCore(fileName + "_core.xml");
                defaultFileStream = RecipeFactory.class.getResourceAsStream("/assets/" + EnderIO.DOMAIN + "/config/" + fileName + "_core.xml");
                if (defaultFileStream == null) {
                    throw new IOException("Could not get resource /assets/" + EnderIO.DOMAIN + "/config/" + fileName + "_core.xml from classpath. ");
                }
                defaultConfig = RecipeFactory.readStax(target.copy(target), rootElement, defaultFileStream);
                configFile = new File(Config.configDirectory, fileName + "_user.xml");
                if (!configFile.exists()) break block9;
                userFileStream = new FileInputStream(configFile);
                userConfig = RecipeFactory.readStax(target, rootElement, userFileStream);
                userConfig.addRecipes(defaultConfig);
                recipeRoot = userConfig;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(userFileStream);
                IOUtils.closeQuietly(defaultFileStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)userFileStream);
            IOUtils.closeQuietly((InputStream)defaultFileStream);
            return (T)recipeRoot;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(configFile, false));
            writer.write(DEFAULT_USER_FILE);
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
        RecipeRoot recipeRoot = defaultConfig;
        IOUtils.closeQuietly((InputStream)userFileStream);
        IOUtils.closeQuietly((InputStream)defaultFileStream);
        return (T)recipeRoot;
    }

    private static <T extends RecipeRoot> T readStax(T target, String rootElement, InputStream in) throws XMLStreamException, InvalidRecipeConfigException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
        StaxFactory factory = new StaxFactory(eventReader);
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement startElement = event.asStartElement();
            if (rootElement.equals(startElement.getName().getLocalPart())) {
                return factory.read(target, startElement);
            }
            throw new InvalidRecipeConfigException("Unexpected tag '" + startElement.getName() + "'");
        }
        throw new InvalidRecipeConfigException("Missing recipes tag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyCore(String filename) {
        FileOutputStream schemaOut;
        InputStream schemaIn;
        block3: {
            schemaIn = null;
            schemaOut = null;
            try {
                File file = new File(Config.configDirectory, filename);
                schemaIn = RecipeFactory.class.getResourceAsStream("/assets/" + EnderIO.DOMAIN + "/config/" + filename);
                if (schemaIn == null) break block3;
                schemaOut = new FileOutputStream(file);
                IOUtils.copy((InputStream)schemaIn, (OutputStream)schemaOut);
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(schemaIn);
                IOUtils.closeQuietly(schemaOut);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(schemaIn);
                IOUtils.closeQuietly(schemaOut);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)schemaIn);
        IOUtils.closeQuietly(schemaOut);
    }
}

