/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BucketHandler {
    public static BucketHandler instance = new BucketHandler();
    private Map<BlockFluidClassic, Item> buckets = new HashMap<BlockFluidClassic, Item>();

    private BucketHandler() {
    }

    public void registerFluid(BlockFluidClassic fluidBlock, Item fullBucket) {
        this.buckets.put(fluidBlock, fullBucket);
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        ItemStack res;
        if (event != null && !event.isCanceled() && event.getTarget() != null && event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && event.getTarget().func_178782_a() != null && event.getFilledBucket() == null && event.getEntityPlayer() != null && event.getWorld() != null && event.getWorld().func_175660_a(event.getEntityPlayer(), event.getTarget().func_178782_a()) && event.getEmptyBucket() != null && event.getEmptyBucket().func_77973_b() == Items.field_151133_ar && event.getEmptyBucket().field_77994_a > 0 && event.getTarget().field_178784_b != null && event.getEntityPlayer().func_175151_a(event.getTarget().func_178782_a().func_177972_a(event.getTarget().field_178784_b), event.getTarget().field_178784_b, event.getEmptyBucket()) && (res = this.getFilledBucket(event.getWorld(), event.getTarget())) != null) {
            event.setFilledBucket(res);
            event.setResult(Event.Result.ALLOW);
        }
    }

    private ItemStack getFilledBucket(World world, RayTraceResult pos) {
        Item bucket;
        BlockPos blockPos = pos.func_178782_a();
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (block instanceof BlockFluidClassic && this.buckets.containsKey(block) && ((BlockFluidClassic)block).isSourceBlock((IBlockAccess)world, blockPos) && (bucket = this.buckets.get(block)) != null) {
            world.func_175698_g(blockPos);
            return new ItemStack(bucket);
        }
        return null;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }
}

