/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.gui;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.generator.stirling.StirlingGeneratorContainer;
import crazypants.enderio.machine.generator.stirling.TileEntityStirlingGenerator;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class TooltipHandlerBurnTime
implements SpecialTooltipHandler.ITooltipCallback {
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        int time = 0;
        TileEntityStirlingGenerator gen = this.getStirlingGen(itemstack);
        if (this.isStirlingGen(itemstack, gen)) {
            int rate = gen.getPowerUsePerTick();
            String msg = MessageFormat.format(EnderIO.lang.localize("power.generates"), PowerDisplayUtil.formatPower((long)gen.getBurnTime(itemstack) * (long)rate), PowerDisplayUtil.abrevation(), PowerDisplayUtil.formatPower(rate), PowerDisplayUtil.abrevation(), PowerDisplayUtil.perTickStr());
            list.add(msg);
        } else if (Config.addFurnaceFuelTootip && (time = TileEntityFurnace.func_145952_a((ItemStack)itemstack)) > 0) {
            list.add(MessageFormat.format(EnderIO.lang.localize("tooltip.burntime"), time));
        }
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    public boolean shouldHandleItem(ItemStack item) {
        int time = TileEntityFurnace.func_145952_a((ItemStack)item);
        return time > 0 || this.isStirlingGen(item);
    }

    private TileEntityStirlingGenerator getStirlingGen(ItemStack stack) {
        AbstractMachineEntity te;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_71070_bA instanceof StirlingGeneratorContainer && (te = (AbstractMachineEntity)((StirlingGeneratorContainer)player.field_71070_bA).getInv()) instanceof TileEntityStirlingGenerator) {
            return (TileEntityStirlingGenerator)te;
        }
        return null;
    }

    private boolean isStirlingGen(ItemStack stack) {
        return this.isStirlingGen(stack, this.getStirlingGen(stack));
    }

    private boolean isStirlingGen(ItemStack stack, TileEntityStirlingGenerator gen) {
        return gen == null ? false : gen.getBurnTime(stack) > 0;
    }
}

