/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.common.vecmath.Vector4i;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class PowerBarOverlayRenderHelper {
    private static final boolean MIMIC_VANILLA_RENDERBUG = false;
    private static final boolean HIDE_VANILLA_RENDERBUG = true;
    private static final boolean SHOW_ON_FULL = false;
    private static final boolean SHOW_ON_FULL_UPGRADEABLE = true;
    private static final boolean SHOW_ON_EMPTY = true;
    private static final boolean SHOW_ON_EMPTY_UPGRADEABLE = true;
    private static final double BAR_W = 12.0;
    protected Vector4i colorShadow = new Vector4i(0, 0, 0, 255);
    protected Vector4i colorBarLeft = new Vector4i(2, 3, 96, 255);
    protected Vector4i colorBarRight = new Vector4i(45, 206, 250, 255);
    protected Vector4i colorBG = new Vector4i(0, 0, 48, 255);
    public static final PowerBarOverlayRenderHelper instance = new PowerBarOverlayRenderHelper(false);
    public static final PowerBarOverlayRenderHelper instance_upgradeable = new PowerBarOverlayRenderHelper(true);
    public static final FluidBarOverlayRenderHelper instance_fluid = new FluidBarOverlayRenderHelper();
    private final boolean isUpgradeableItem;

    protected PowerBarOverlayRenderHelper(boolean isUpgradeableItem) {
        this.isUpgradeableItem = isUpgradeableItem;
    }

    public boolean render(ItemStack stack, int xPosition, int yPosition) {
        int energy;
        IEnergyContainerItem energyItem;
        int maxEnergy;
        if (this.hasEnergyStore(stack) && stack.func_77973_b() instanceof IEnergyContainerItem && (maxEnergy = (energyItem = (IEnergyContainerItem)stack.func_77973_b()).getMaxEnergyStored(stack)) > 0 && this.shouldShowBar(maxEnergy, energy = energyItem.getEnergyStored(stack))) {
            boolean top;
            double level = (double)energy / (double)maxEnergy;
            boolean up = stack.func_77973_b().showDurabilityBar(stack);
            boolean bl = top = stack.field_77994_a != 1;
            this.render(level, xPosition, yPosition, top ? 12 : (up ? 2 : 0), true);
            return true;
        }
        if (stack.func_77973_b().showDurabilityBar(stack)) {
            this.overpaintVanillaRenderBug(xPosition, yPosition);
        }
        return false;
    }

    protected boolean shouldShowBar(int maxEnergy, int energy) {
        if (energy < 0 || energy > maxEnergy) {
            return false;
        }
        if (energy == 0) {
            return this.isUpgradeableItem ? true : true;
        }
        if (energy == maxEnergy) {
            return this.isUpgradeableItem;
        }
        return true;
    }

    protected boolean hasEnergyStore(ItemStack stack) {
        return stack != null && (!this.isUpgradeableItem || EnergyUpgrade.loadFromItem(stack) != null);
    }

    public void render(double level, int xPosition, int yPosition, int offset, boolean shadow) {
        double width = level * 12.0;
        GlStateManager.func_179145_e();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.drawPlain(worldrenderer, xPosition + 2, yPosition + 13 - offset, 13.0, shadow ? 2 : 1, this.colorShadow);
        this.drawGrad(worldrenderer, xPosition + 2, yPosition + 13 - offset, (12.0 + width) / 2.0, 1, this.colorBarLeft, this.colorBarRight);
        this.drawRight(worldrenderer, xPosition + 2 + 12, yPosition + 13 - offset, 12.0 - width, 1, this.colorBG);
        if (offset == 2) {
            this.overpaintVanillaRenderBug(worldrenderer, xPosition, yPosition);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    protected void drawGrad(VertexBuffer renderer, int x, int y, double width, int height, Vector4i colorL, Vector4i colorR) {
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181669_b(colorL.x, colorL.y, colorL.z, colorL.w).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181669_b(colorL.x, colorL.y, colorL.z, colorL.w).func_181675_d();
        renderer.func_181662_b((double)x + width, (double)(y + height), 0.0).func_181669_b(colorR.x, colorR.y, colorR.z, colorR.w).func_181675_d();
        renderer.func_181662_b((double)x + width, (double)(y + 0), 0.0).func_181669_b(colorR.x, colorR.y, colorR.z, colorR.w).func_181675_d();
    }

    protected void drawPlain(VertexBuffer renderer, int x, int y, double width, int height, Vector4i color) {
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181669_b(color.x, color.y, color.z, color.w).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181669_b(color.x, color.y, color.z, color.w).func_181675_d();
        renderer.func_181662_b((double)x + width, (double)(y + height), 0.0).func_181669_b(color.x, color.y, color.z, color.w).func_181675_d();
        renderer.func_181662_b((double)x + width, (double)(y + 0), 0.0).func_181669_b(color.x, color.y, color.z, color.w).func_181675_d();
    }

    protected void drawRight(VertexBuffer renderer, int x, int y, double width, int height, Vector4i color) {
        renderer.func_181662_b((double)x - width, (double)(y + 0), 0.0).func_181669_b(color.x, color.y, color.z, color.w).func_181675_d();
        renderer.func_181662_b((double)x - width, (double)(y + height), 0.0).func_181669_b(color.x, color.y, color.z, color.w).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181669_b(color.x, color.y, color.z, color.w).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + 0), 0.0).func_181669_b(color.x, color.y, color.z, color.w).func_181675_d();
    }

    protected void overpaintVanillaRenderBug(int xPosition, int yPosition) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.overpaintVanillaRenderBug(worldrenderer, xPosition, yPosition);
        tessellator.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    protected void overpaintVanillaRenderBug(VertexBuffer worldrenderer, int xPosition, int yPosition) {
        this.drawPlain(worldrenderer, xPosition + 2 + 12, yPosition + 13, 1.0, 1, this.colorShadow);
    }

    public static class FluidBarOverlayRenderHelper
    extends PowerBarOverlayRenderHelper {
        protected FluidBarOverlayRenderHelper() {
            super(false);
            this.colorBarLeft = new Vector4i(118, 132, 82, 255);
            this.colorBarRight = new Vector4i(172, 219, 57, 255);
            this.colorBG = new Vector4i(0, 48, 0, 255);
        }

        @Override
        public boolean render(ItemStack stack, int xPosition, int yPosition) {
            return this.render(stack, xPosition, yPosition, 0);
        }

        public boolean render(ItemStack stack, int xPosition, int yPosition, int barOffset) {
            IFluidContainerItem fluidItem;
            int maxFluid;
            if (stack.func_77973_b() instanceof IFluidContainerItem && (maxFluid = (fluidItem = (IFluidContainerItem)stack.func_77973_b()).getCapacity(stack)) > 0) {
                int fluid;
                FluidStack fluidStack = fluidItem.getFluid(stack);
                int n = fluid = fluidStack == null ? 0 : fluidStack.amount;
                if (this.shouldShowBar(maxFluid, fluid)) {
                    boolean top;
                    double level = (double)fluid / (double)maxFluid;
                    boolean up = stack.func_77973_b().showDurabilityBar(stack);
                    boolean bl = top = stack.field_77994_a != 1;
                    this.render(level, xPosition, yPosition, top ? 12 - barOffset : (up ? 2 + barOffset : barOffset), (barOffset & 1) == 0);
                    return true;
                }
            }
            return false;
        }
    }
}

