/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Multimap;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.IHasPlayerRenderer;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IDarkSteelUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IRenderUpgrade;
import crazypants.enderio.item.darksteel.upgrade.PaintedHelmetLayer;
import crazypants.enderio.paint.PainterUtil2;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.items.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.items.IVisDiscountGear", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.items.IRevealer", modid="Thaumcraft")})
public class ItemDarkSteelArmor
extends ItemArmor
implements IEnergyContainerItem,
ISpecialArmor,
IAdvancedTooltipProvider,
IDarkSteelItem,
EnderCoreMethods.IOverlayRenderAware,
IHasPlayerRenderer,
PainterUtil2.IWithPaintName {
    public static final ItemArmor.ArmorMaterial MATERIAL = ItemDarkSteelArmor.createMaterial();
    public static final int[] CAPACITY = new int[]{Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase * 2, Config.darkSteelPowerStorageBase * 2};
    public static final int[] RF_PER_DAMAGE_POINT = new int[]{Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase * 2, Config.darkSteelPowerStorageBase * 2};
    public static final String[] NAMES = new String[]{"boots", "leggings", "chestplate", "helmet"};
    boolean gogglesUgradeActive = true;
    private final int powerPerDamagePoint;
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    private static ItemArmor.ArmorMaterial createMaterial() {
        Class[] params = new Class[]{String.class, Integer.TYPE, int[].class, Integer.TYPE, SoundEvent.class, Float.TYPE};
        return (ItemArmor.ArmorMaterial)EnumHelper.addEnum(ItemArmor.ArmorMaterial.class, (String)"darkSteel", (Class[])params, (Object[])new Object[]{"darkSteel", 35, new int[]{2, 5, 6, 2}, 15, SoundEvents.field_187725_r, Float.valueOf(1.0f)});
    }

    public static ItemDarkSteelArmor forArmorType(int armorType) {
        switch (armorType) {
            case 0: {
                return DarkSteelItems.itemDarkSteelBoots;
            }
            case 1: {
                return DarkSteelItems.itemDarkSteelLeggings;
            }
            case 2: {
                return DarkSteelItems.itemDarkSteelChestplate;
            }
            case 3: {
                return DarkSteelItems.itemDarkSteelHelmet;
            }
        }
        return null;
    }

    public static ItemDarkSteelArmor forArmorType(EntityEquipmentSlot armorType) {
        switch (armorType) {
            case HEAD: {
                return DarkSteelItems.itemDarkSteelHelmet;
            }
            case CHEST: {
                return DarkSteelItems.itemDarkSteelChestplate;
            }
            case LEGS: {
                return DarkSteelItems.itemDarkSteelLeggings;
            }
            case FEET: {
                return DarkSteelItems.itemDarkSteelBoots;
            }
        }
        return null;
    }

    public static int getPoweredProtectionIncrease(int armorType) {
        switch (armorType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public static ItemDarkSteelArmor create(EntityEquipmentSlot armorType) {
        ItemDarkSteelArmor res = new ItemDarkSteelArmor(armorType);
        res.init();
        return res;
    }

    protected ItemDarkSteelArmor(EntityEquipmentSlot armorType) {
        super(MATERIAL, 0, armorType);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        String str = "darkSteel_" + NAMES[armorType.func_188454_b()];
        this.func_77655_b(str);
        this.setRegistryName(str);
        this.powerPerDamagePoint = Config.darkSteelPowerStorageBase / MATERIAL.func_78046_a(armorType);
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @Override
    public String getItemName() {
        String regName = this.func_77658_a();
        regName = regName.substring(5, regName.length());
        return regName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        Iterator<IDarkSteelUpgrade> iter = DarkSteelRecipeManager.instance.recipeIterator();
        while (iter.hasNext()) {
            IDarkSteelUpgrade upgrade = iter.next();
            if (upgrade instanceof EnergyUpgrade || !upgrade.canAddToItem(is)) continue;
            upgrade.writeToItem(is);
        }
        par3List.add(is);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        switch (this.field_77881_a) {
            case HEAD: {
                return 5;
            }
            case CHEST: {
                return 8;
            }
            case LEGS: {
                return 7;
            }
        }
        return 4;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD) {
            list.add(PainterUtil2.getTooltTipText(itemstack));
        }
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(TextFormatting.WHITE + EnderIO.lang.localize("item.darkSteel_armor.tooltip.line1"));
            list.add(TextFormatting.WHITE + EnderIO.lang.localize("item.darkSteel_armor.tooltip.line2"));
            if (itemstack.func_77973_b() == DarkSteelItems.itemDarkSteelBoots) {
                list.add(TextFormatting.WHITE + EnderIO.lang.localize("item.darkSteel_boots.tooltip.line1"));
                list.add(TextFormatting.WHITE + EnderIO.lang.localize("item.darkSteel_boots.tooltip.line2"));
            }
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public String getArmorTexture(ItemStack itemStack, Entity entity, EntityEquipmentSlot slot, String layer) {
        if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
            return "enderio:textures/models/armor/darkSteel_layer_2.png";
        }
        return "enderio:textures/models/armor/darkSteel_layer_1.png";
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, armor.func_77958_k() + 1 - armor.func_77952_i());
        }
        double damageRatio = this.field_77879_b + (this.getEnergyStored(armor) > 0 ? ItemDarkSteelArmor.getPoweredProtectionIncrease(3 - slot) : 0);
        ISpecialArmor.ArmorProperties ap = new ISpecialArmor.ArmorProperties(0, damageRatio /= 25.0, armor.func_77958_k() + 1 - armor.func_77952_i());
        return ap;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        int powerBonus = this.getEnergyStored(armor) > 0 ? ItemDarkSteelArmor.getPoweredProtectionIncrease(3 - slot) : 0;
        return this.func_82812_d().func_78044_b(this.field_77881_a) + powerBonus;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == this.field_77881_a) {
            boolean isPowered;
            boolean bl = isPowered = this.getEnergyStored(stack) > 0;
            if (isPowered) {
                boolean toughnessBonus = true;
                multimap.removeAll((Object)SharedMonsterAttributes.field_189429_h.func_111108_a());
                multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor toughness", (double)(this.field_189415_e + (float)toughnessBonus), 0));
                int powerBonus = ItemDarkSteelArmor.getPoweredProtectionIncrease(3 - equipmentSlot.func_188454_b());
                multimap.removeAll((Object)SharedMonsterAttributes.field_188791_g.func_111108_a());
                multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", (double)(this.field_77879_b + powerBonus), 0));
            }
        }
        return multimap;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
            eu.extractEnergy(damage * this.powerPerDamagePoint, false);
        } else {
            stack.func_77972_a(damage, entity);
        }
        if (eu != null) {
            eu.writeToItem(stack);
        }
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean isGogglesUgradeActive() {
        return this.gogglesUgradeActive;
    }

    public void setGogglesUgradeActive(boolean gogglesUgradeActive) {
        this.gogglesUgradeActive = gogglesUgradeActive;
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IRenderUpgrade getRender() {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD) {
            return PaintedHelmetLayer.instance;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD && itemStack != null && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("DSPAINT")) {
            return new ModelBiped(){

                public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                }
            };
        }
        return null;
    }

    @Override
    public String getPaintName(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("DSPAINT")) {
            ItemStack paintSource = ItemStack.func_77949_a((NBTTagCompound)itemStack.func_77978_p().func_74775_l("DSPAINT"));
            if (paintSource == null) {
                return null;
            }
            return paintSource.func_82833_r();
        }
        return null;
    }
}

