/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.jei;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.jei.BaseRecipeHandler;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.ContainerPainter;
import crazypants.enderio.machine.painter.GuiPainter;
import crazypants.enderio.machine.painter.recipe.AbstractPainterTemplate;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.util.NbtValue;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.Internal;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ingredients.GuiIngredientGroup;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;

public class PainterRecipeCategory
extends BlankRecipeCategory<PainterRecipeWrapper> {
    @Nonnull
    public static final String UID = "Painter";
    private static final int xOff = 34;
    private static final int yOff = 28;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    protected final IDrawableAnimated arror;

    private static List<PainterRecipeWrapper> splitRecipes(@Nonnull Collection<IMachineRecipe> recipes, List<ItemStack> validItems) {
        long start = System.nanoTime();
        ArrayList<AbstractPainterTemplate> basicPainterTemplates = new ArrayList<AbstractPainterTemplate>();
        for (IMachineRecipe iMachineRecipe : recipes) {
            if (!(iMachineRecipe instanceof AbstractPainterTemplate)) continue;
            basicPainterTemplates.add((AbstractPainterTemplate)iMachineRecipe);
        }
        ArrayList<PainterRecipeWrapper> recipesWrappers = new ArrayList<PainterRecipeWrapper>();
        for (ItemStack target : validItems) {
            for (AbstractPainterTemplate basicPainterTemplate : basicPainterTemplates) {
                if (!basicPainterTemplate.isValidTarget(target)) continue;
                recipesWrappers.add(new PainterRecipeWrapper(basicPainterTemplate, target, new ArrayList<ItemStack>(), new ArrayList<ItemStack>()));
            }
        }
        List<ItemStack> list = Config.jeiUseShortenedPainterRecipes ? PainterRecipeCategory.getLimitedItems() : validItems;
        int count = 0;
        for (ItemStack paint : list) {
            try {
                for (PainterRecipeWrapper painterRecipeWrapper : recipesWrappers) {
                    if (!painterRecipeWrapper.recipe.isRecipe(paint, painterRecipeWrapper.target)) continue;
                    for (IMachineRecipe.ResultStack result : painterRecipeWrapper.recipe.getCompletedResult(paint, painterRecipeWrapper.target)) {
                        painterRecipeWrapper.results.add(result.item);
                        painterRecipeWrapper.paints.add(paint);
                        ++count;
                    }
                }
            }
            catch (Exception e) {
                Log.warn("PainterRecipeCategory: Error while accessing item '" + paint + "': " + e);
                e.printStackTrace();
            }
        }
        long end = System.nanoTime();
        for (PainterRecipeWrapper painterRecipeWrapper : recipesWrappers) {
            if (!painterRecipeWrapper.results.isEmpty()) continue;
            Log.warn("PainterRecipeCategory: Empty recipe group: " + painterRecipeWrapper.recipe + " for " + painterRecipeWrapper.target);
        }
        Log.info(String.format("PainterRecipeCategory: Added %d painter recipes in %d groups to JEI in %.3f seconds.", count, recipesWrappers.size(), (double)(end - start) / 1.0E9));
        return recipesWrappers;
    }

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PainterRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<PainterRecipeWrapper>(PainterRecipeWrapper.class, UID)});
        registry.addRecipeClickArea(GuiPainter.class, 155, 42, 16, 16, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)EnderIO.blockPainter), new String[]{UID});
        registry.addRecipes(PainterRecipeCategory.splitRecipes(MachineRecipeRegistry.instance.getRecipesForMachine(ModObject.blockPainter.getUnlocalisedName()).values(), PainterRecipeCategory.getValidItems()));
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerPainter.class, UID, ContainerPainter.FIRST_RECIPE_SLOT, ContainerPainter.NUM_RECIPE_SLOT, ContainerPainter.FIRST_INVENTORY_SLOT, ContainerPainter.NUM_INVENTORY_SLOT);
    }

    public PainterRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("painter");
        this.background = guiHelper.createDrawable(backgroundLocation, 34, 28, 120, 50);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 176, 14, 24, 16);
        this.arror = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        String localizedName = EnderIO.blockPainter.func_149732_F();
        return localizedName != null ? localizedName : "ERROR";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.arror.draw(minecraft, 54, 6);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull PainterRecipeWrapper currentRecipe) {
        IGuiItemStackGroup guiItemStacks;
        block12: {
            guiItemStacks = recipeLayout.getItemStacks();
            guiItemStacks.init(0, true, 32, 5);
            guiItemStacks.init(1, true, 3, 5);
            guiItemStacks.init(2, false, 86, 5);
            guiItemStacks.set(0, currentRecipe.target);
            if (guiItemStacks instanceof GuiIngredientGroup) {
                try {
                    ArrayList<ItemStack> paints = new ArrayList<ItemStack>();
                    ArrayList<ItemStack> results = new ArrayList<ItemStack>();
                    Field focusField = GuiIngredientGroup.class.getDeclaredField("focus");
                    focusField.setAccessible(true);
                    Focus focus = (Focus)focusField.get(guiItemStacks);
                    if (focus == null || focus.getMode() == IFocus.Mode.NONE) break block12;
                    ItemStack focused = (ItemStack)focus.getValue();
                    if (focus.getMode() == IFocus.Mode.OUTPUT) {
                        for (int i = 0; i < currentRecipe.paints.size(); ++i) {
                            ItemStack resultStack = currentRecipe.results.get(i);
                            ItemStack paintStack = currentRecipe.paints.get(i);
                            if (!Internal.getStackHelper().isEquivalent(focused, resultStack) || !NbtValue.SOURCE_BLOCK.getString(focused).equals(NbtValue.SOURCE_BLOCK.getString(resultStack)) || NbtValue.SOURCE_META.getInt(focused) != NbtValue.SOURCE_META.getInt(resultStack)) continue;
                            paints.add(paintStack);
                            results.add(resultStack);
                        }
                    } else if (!Internal.getStackHelper().isEquivalent(focused, currentRecipe.target)) {
                        for (int i = 0; i < currentRecipe.paints.size(); ++i) {
                            ItemStack resultStack = currentRecipe.results.get(i);
                            ItemStack paintStack = currentRecipe.paints.get(i);
                            if (!Internal.getStackHelper().isEquivalent(focused, paintStack)) continue;
                            paints.add(paintStack);
                            results.add(resultStack);
                        }
                    } else {
                        for (int i = 0; i < currentRecipe.paints.size(); ++i) {
                            ItemStack resultStack = currentRecipe.results.get(i);
                            ItemStack paintStack = currentRecipe.paints.get(i);
                            if (Internal.getStackHelper().isEquivalent(focused, paintStack)) continue;
                            paints.add(paintStack);
                            results.add(resultStack);
                        }
                    }
                    if (!paints.isEmpty()) {
                        guiItemStacks.set(1, paints);
                        guiItemStacks.set(2, results);
                        return;
                    }
                }
                catch (Throwable t) {
                    Log.debug(t.getMessage());
                }
            } else {
                Log.debug("Assertion failed");
            }
        }
        guiItemStacks.set(1, currentRecipe.paints);
        guiItemStacks.set(2, currentRecipe.results);
    }

    @Nonnull
    private static List<ItemStack> getValidItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Item item : GameData.getItemRegistry()) {
            for (CreativeTabs tab : item.getCreativeTabs()) {
                item.func_150895_a(item, tab, list);
            }
        }
        return list;
    }

    @Nonnull
    private static List<ItemStack> getLimitedItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Block block : new Block[]{Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150344_f, Blocks.field_150359_w, Blocks.field_150446_ar, Blocks.field_150328_O, Blocks.field_180399_cE, Blocks.field_150335_W}) {
            Item item = Item.func_150898_a((Block)block);
            if (item == null) continue;
            for (CreativeTabs tab : item.getCreativeTabs()) {
                item.func_150895_a(item, tab, list);
            }
        }
        return list;
    }

    public static class PainterRecipeWrapper
    extends BlankRecipeWrapper {
        final AbstractPainterTemplate<?> recipe;
        final int energyRequired;
        @Nonnull
        final ItemStack target;
        @Nonnull
        final List<ItemStack> paints;
        @Nonnull
        final List<ItemStack> results;

        public PainterRecipeWrapper(@Nonnull AbstractPainterTemplate<?> recipe, @Nonnull ItemStack target, @Nonnull List<ItemStack> paints, @Nonnull List<ItemStack> results) {
            this.recipe = recipe;
            this.energyRequired = recipe.getEnergyRequired(new MachineRecipeInput[0]);
            this.target = target;
            this.paints = paints;
            this.results = results;
        }

        public long getEnergyRequired() {
            return this.energyRequired;
        }

        @Nonnull
        public List<?> getInputs() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.paints);
            list.add(this.target);
            return list;
        }

        @Nonnull
        public List<?> getOutputs() {
            return this.results;
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            String energyString = PowerDisplayUtil.formatPower(this.energyRequired) + " " + PowerDisplayUtil.abrevation();
            minecraft.field_71466_p.func_175065_a(energyString, 6.0f, 36.0f, 0x808080, false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

