/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.Util;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.enchanter.ContainerEnchanter;
import crazypants.enderio.machine.enchanter.GuiEnchanter;
import crazypants.enderio.machine.enchanter.TileEnchanter;
import crazypants.enderio.render.ITESRItemBlock;
import crazypants.enderio.render.SmartModelAttacher;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class BlockEnchanter
extends BlockEio<TileEnchanter>
implements IGuiHandler,
IResourceTooltipProvider,
ITESRItemBlock {
    public static BlockEnchanter create() {
        BlockEnchanter res = new BlockEnchanter();
        res.init();
        return res;
    }

    protected BlockEnchanter() {
        super(ModObject.blockEnchanter.getUnlocalisedName(), TileEnchanter.class);
        this.func_149713_g(0);
    }

    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(91, this);
        SmartModelAttacher.registerItemOnly((Block)this);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEnchanter te = (TileEnchanter)world.func_175625_s(pos);
        te.setFacing(this.getFacingForHeading(heading));
        if (world.field_72995_K) {
            return;
        }
        world.func_184138_a(pos, state, state, 3);
    }

    public EnumBlockRenderType func_149645_b(IBlockState bs) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    protected EnumFacing getFacingForHeading(int heading) {
        switch (heading) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.EAST;
            }
            case 2: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.WEST;
    }

    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)EnderIO.instance, 91, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEnchanter te = (TileEnchanter)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te != null) {
            this.dropItems(worldIn, pos, te);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    private void dropItems(World world, BlockPos pos, TileEnchanter te) {
        if (te.func_70301_a(0) != null) {
            Util.dropItems((World)world, (ItemStack)te.func_70301_a(0), (BlockPos)pos, (boolean)true);
        }
        if (te.func_70301_a(1) != null) {
            Util.dropItems((World)world, (ItemStack)te.func_70301_a(1), (BlockPos)pos, (boolean)true);
        }
    }

    public int func_149745_a(Random p_149745_1_) {
        return 1;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(IBlockState bs) {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileEnchanter) {
            return new ContainerEnchanter(player, player.field_71071_by, (TileEnchanter)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileEnchanter) {
            return new GuiEnchanter(player, player.field_71071_by, (TileEnchanter)te);
        }
        return null;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }
}

