/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import com.enderio.core.common.util.Util;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.enchanter.EnchanterRecipe;
import crazypants.enderio.machine.enchanter.EnchanterRecipeManager;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

@Storable
public class TileEnchanter
extends TileEntityEio
implements ISidedInventory {
    @Store
    private ItemStack[] inv = new ItemStack[4];
    @Store
    private EnumFacing facing = EnumFacing.NORTH;

    public void setFacing(EnumFacing s) {
        this.facing = s;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inv.length) {
            return null;
        }
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return Util.decrStackSize((IInventory)this, (int)slot, (int)amount);
    }

    public void func_70299_a(int slot, @Nullable ItemStack contents) {
        this.inv[slot] = contents == null ? contents : contents.func_77946_l();
        if (contents != null && contents.field_77994_a > this.func_70297_j_()) {
            contents.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70304_b(int index) {
        ItemStack res = this.func_70301_a(index);
        this.func_70299_a(index, res);
        return res;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = null;
        }
    }

    public String func_70005_c_() {
        return ModObject.blockEnchanter.getUnlocalisedName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer p) {
    }

    public void func_174886_c(EntityPlayer p) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (slot == 0) {
            return Items.field_151099_bA == stack.func_77973_b();
        }
        if (slot == 1) {
            return EnchanterRecipeManager.getInstance().getEnchantmentRecipeForInput(stack) != null;
        }
        if (slot == 2) {
            return stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 4;
        }
        return false;
    }

    public EnchanterRecipe getCurrentEnchantmentRecipe() {
        if (this.inv[0] == null) {
            return null;
        }
        if (this.inv[1] == null) {
            return null;
        }
        if (this.inv[2] == null) {
            return null;
        }
        EnchanterRecipe ench = EnchanterRecipeManager.getInstance().getEnchantmentRecipeForInput(this.inv[1]);
        if (ench == null) {
            return null;
        }
        int level = ench.getLevelForStackSize(this.inv[1].field_77994_a);
        if (level <= 0) {
            return null;
        }
        if (this.inv[2].field_77994_a < ench.getLapizForStackSize(this.inv[1].field_77994_a)) {
            return null;
        }
        return ench;
    }

    public EnchantmentData getCurrentEnchantmentData() {
        EnchanterRecipe rec = this.getCurrentEnchantmentRecipe();
        if (rec == null) {
            return null;
        }
        int level = rec.getLevelForStackSize(this.inv[1].field_77994_a);
        return new EnchantmentData(rec.getEnchantment(), level);
    }

    public int getCurrentEnchantmentCost() {
        return this.getEnchantmentCost(this.getCurrentEnchantmentRecipe());
    }

    private int getEnchantmentCost(EnchanterRecipe currentEnchantment) {
        ItemStack item = this.inv[1];
        if (item == null) {
            return 0;
        }
        if (currentEnchantment == null) {
            return 0;
        }
        int level = currentEnchantment.getLevelForStackSize(item.field_77994_a);
        return currentEnchantment.getCostForLevel(level);
    }

    public void setOutput(ItemStack output) {
        this.inv[this.inv.length - 1] = output;
        this.func_70296_d();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }
}

