/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.FarmingStationRenderMapper;
import crazypants.enderio.machine.farm.GuiFarmStation;
import crazypants.enderio.machine.farm.PacketFarmAction;
import crazypants.enderio.machine.farm.PacketFarmLockedSlot;
import crazypants.enderio.machine.farm.PacketUpdateNotification;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.IRenderMapper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFarmStation
extends AbstractMachineBlock<TileFarmStation>
implements IPaintable.INonSolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockFarmStation create() {
        PacketHandler.INSTANCE.registerMessage(PacketFarmAction.class, PacketFarmAction.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketUpdateNotification.class, PacketUpdateNotification.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketFarmLockedSlot.class, PacketFarmLockedSlot.class, PacketHandler.nextID(), Side.SERVER);
        BlockFarmStation result = new BlockFarmStation();
        result.init();
        return result;
    }

    protected BlockFarmStation() {
        super(ModObject.blockFarmStation, TileFarmStation.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileFarmStation te = (TileFarmStation)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        if (te != null) {
            return new FarmStationContainer(player.field_71071_by, te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileFarmStation te = (TileFarmStation)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        if (te != null) {
            return new GuiFarmStation(player.field_71071_by, te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 22;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOMode.EnumIOMode mapIOMode(IoMode mode, EnumFacing side) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            switch (mode) {
                case NONE: {
                    return IOMode.EnumIOMode.NONE;
                }
                case PULL: {
                    return IOMode.EnumIOMode.PULL;
                }
                case PUSH: {
                    return IOMode.EnumIOMode.PUSH;
                }
                case PUSH_PULL: {
                    return IOMode.EnumIOMode.PUSHPULL;
                }
                case DISABLED: {
                    return IOMode.EnumIOMode.DISABLED;
                }
            }
        } else {
            switch (mode) {
                case NONE: {
                    return IOMode.EnumIOMode.NONE;
                }
                case PULL: {
                    return IOMode.EnumIOMode.PULLSIDES;
                }
                case PUSH: {
                    return IOMode.EnumIOMode.PUSHSIDES;
                }
                case PUSH_PULL: {
                    return IOMode.EnumIOMode.PUSHPULLSIDES;
                }
                case DISABLED: {
                    return IOMode.EnumIOMode.DISABLEDSIDES;
                }
            }
        }
        throw new RuntimeException("Hey, leave our enums alone!");
    }

    public boolean func_176225_a(IBlockState bs, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    @Override
    public void func_180655_c(IBlockState bs, World world, BlockPos pos, Random rand) {
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_149739_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return FarmingStationRenderMapper.instance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return FarmingStationRenderMapper.instance;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileFarmStation tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.isActive());
    }
}

