/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.farm.FarmNotification;
import crazypants.enderio.machine.farm.TileFarmStation;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateNotification
extends MessageTileEntity<TileFarmStation>
implements IMessageHandler<PacketUpdateNotification, IMessage> {
    private Set<FarmNotification> notification;

    public PacketUpdateNotification() {
    }

    public PacketUpdateNotification(TileFarmStation tile, Set<FarmNotification> notification) {
        super((TileEntity)tile);
        this.notification = notification;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.notification = EnumSet.noneOf(FarmNotification.class);
        int count = buf.readByte();
        for (int i = 0; i < count; ++i) {
            this.notification.add(FarmNotification.values()[buf.readByte()]);
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.notification.size());
        for (FarmNotification farmNotification : this.notification) {
            buf.writeByte(farmNotification.ordinal());
        }
    }

    public IMessage onMessage(PacketUpdateNotification message, MessageContext ctx) {
        TileFarmStation te = (TileFarmStation)message.getTileEntity(EnderIO.proxy.getClientWorld());
        if (te != null) {
            te.notification = message.notification;
        }
        return null;
    }
}

