/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CocoaFarmer
extends CustomSeedFarmer {
    public CocoaFarmer() {
        super(Blocks.field_150375_by, new ItemStack(Items.field_151100_aR, 1, 3));
        this.requiresFarmland = false;
        if (!Config.farmHarvestJungleWhenCocoa) {
            this.disableTreeFarm = true;
        }
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        return block == this.getPlantedBlock() && (Integer)meta.func_177229_b((IProperty)BlockCocoa.field_176501_a) == 2;
    }

    @Override
    protected boolean plant(TileFarmStation farm, World worldObj, BlockCoord bc) {
        EnumFacing dir = this.getPlantDirection(worldObj, bc);
        if (dir == null) {
            return false;
        }
        IBlockState iBlockState = this.getPlantedBlock().func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)dir);
        if (worldObj.func_180501_a(bc.getBlockPos(), iBlockState, 3)) {
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    @Override
    protected boolean canPlant(TileFarmStation farm, World worldObj, BlockCoord bc) {
        return this.getPlantDirection(worldObj, bc) != null;
    }

    private EnumFacing getPlantDirection(World worldObj, BlockCoord bc) {
        if (!worldObj.func_175623_d(bc.getBlockPos())) {
            return null;
        }
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            BlockPos p = bc.getBlockPos().func_177972_a(dir);
            if (!this.validBlock(worldObj.func_180495_p(p))) continue;
            return dir;
        }
        return null;
    }

    private boolean validBlock(IBlockState iblockstate) {
        return iblockstate.func_177230_c() == Blocks.field_150364_r && iblockstate.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE;
    }
}

