/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.combustion;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.RenderMappers;
import crazypants.enderio.machine.generator.combustion.ContainerCombustionEngine;
import crazypants.enderio.machine.generator.combustion.GuiCombustionGenerator;
import crazypants.enderio.machine.generator.combustion.PacketCombustionTank;
import crazypants.enderio.machine.generator.combustion.TileCombustionGenerator;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCombustionGenerator
extends AbstractMachineBlock<TileCombustionGenerator>
implements IPaintable.INonSolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockCombustionGenerator create() {
        PacketHandler.INSTANCE.registerMessage(PacketCombustionTank.class, PacketCombustionTank.class, PacketHandler.nextID(), Side.CLIENT);
        BlockCombustionGenerator gen = new BlockCombustionGenerator();
        gen.init();
        return gen;
    }

    protected BlockCombustionGenerator() {
        super(ModObject.blockCombustionGenerator, TileCombustionGenerator.class);
    }

    public int func_149717_k(IBlockState bs) {
        return 0;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileCombustionGenerator te;
        if (world != null && (te = (TileCombustionGenerator)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z))) != null) {
            return new ContainerCombustionEngine(player.field_71071_by, te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileCombustionGenerator te;
        if (world != null && (te = (TileCombustionGenerator)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z))) != null) {
            return new GuiCombustionGenerator(player.field_71071_by, te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 21;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    @Override
    public void func_180655_c(IBlockState bs, World world, BlockPos pos, Random rand) {
        if (world != null && pos != null && this.isActive((IBlockAccess)world, pos)) {
            TileEntity te = world.func_175625_s(pos);
            EnumFacing facing = EnumFacing.SOUTH;
            if (te instanceof AbstractMachineEntity) {
                AbstractMachineEntity me = (AbstractMachineEntity)te;
                facing = me.facing;
            }
            EnumFacing dir = facing;
            float startX = (float)pos.func_177958_n() + (dir.func_82601_c() == 0 ? 0.5f : 0.0f);
            float startY = (float)pos.func_177956_o() + 0.5f;
            float startZ = (float)pos.func_177952_p() + (dir.func_82599_e() == 0 ? 0.5f : 0.0f);
            if (dir.func_82601_c() == 1) {
                startX += 1.0f;
            } else if (dir.func_82599_e() == 1) {
                startZ += 1.0f;
            }
            for (int i = 0; i < 2; ++i) {
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                float zOffset = 0.0f;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(startX + xOffset), (double)(startY + yOffset), (double)(startZ + zOffset), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileCombustionGenerator tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive());
    }
}

