/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.stirling;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.AbstractGeneratorEntity;
import crazypants.enderio.machine.generator.stirling.PacketBurnTime;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.power.PowerDistributor;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileEntityStirlingGenerator
extends AbstractGeneratorEntity
implements IProgressTile,
IPaintable.IPaintableTileEntity {
    public static final String SOUND_NAME = "generator.stirling";
    @Store
    public int burnTime = 0;
    @Store
    public int totalBurnTime;
    @Store
    public boolean isLavaFired;
    private PowerDistributor powerDis;

    public TileEntityStirlingGenerator() {
        super(new SlotDefinition(1, 0), null, CapacitorKey.STIRLING_POWER_BUFFER, CapacitorKey.STIRLING_POWER_GEN);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockStirlingGenerator.getUnlocalisedName();
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return "Stirling Generator";
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return TileEntityFurnace.func_145954_b((ItemStack)itemstack);
    }

    @Override
    @Nonnull
    public int[] func_180463_a(EnumFacing var1) {
        return new int[]{0};
    }

    @Override
    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing j) {
        return this.func_94041_b(i, itemstack);
    }

    @Override
    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing j) {
        return !TileEntityFurnace.func_145954_b((ItemStack)itemstack);
    }

    @Override
    public boolean isActive() {
        return this.burnTime > 0;
    }

    public float getProgress() {
        if (this.totalBurnTime <= 0) {
            return 0.0f;
        }
        return (float)this.burnTime / (float)this.totalBurnTime;
    }

    public void setProgress(float progress) {
        this.burnTime = (int)((float)this.totalBurnTime * progress);
    }

    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public String getSoundName() {
        return SOUND_NAME;
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    public int getBurnTime(ItemStack item) {
        return Math.round((float)TileEntityFurnace.func_145952_a((ItemStack)item) * this.getBurnTimeMultiplier());
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        boolean needsUpdate = false;
        boolean sendBurnTimePacket = false;
        if (this.burnTime > 0) {
            if (this.getEnergyStored() < this.getMaxEnergyStored()) {
                this.setEnergyStored(this.getEnergyStored() + this.getPowerUsePerTick());
            }
            --this.burnTime;
            sendBurnTimePacket = this.shouldDoWorkThisTick(20, -1) || this.burnTime == 0;
        }
        this.transmitEnergy();
        if (redstoneCheck && this.burnTime <= 0 && this.getEnergyStored() < this.getMaxEnergyStored() && this.inventory[0] != null && this.inventory[0].field_77994_a > 0) {
            this.burnTime = this.getBurnTime(this.inventory[0]);
            if (this.burnTime > 0) {
                this.totalBurnTime = this.burnTime;
                this.isLavaFired = this.inventory[0].func_77973_b() == Items.field_151129_at;
                ItemStack containedItem = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                if (containedItem != null) {
                    if (this.inventory[0].field_77994_a == 1) {
                        this.inventory[0] = containedItem;
                    } else {
                        this.func_70298_a(0, 1);
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, containedItem));
                    }
                } else {
                    this.func_70298_a(0, 1);
                }
                needsUpdate = true;
            }
        }
        if (!needsUpdate && sendBurnTimePacket) {
            PacketHandler.sendToAllAround((IMessage)new PacketBurnTime(this), (TileEntity)this);
        }
        return needsUpdate;
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        if (dir == null) {
            return false;
        }
        if (this.inventory[0] == null) {
            return false;
        }
        if (!this.shouldDoWorkThisTick(20)) {
            return false;
        }
        if (!this.func_180461_b(0, this.inventory[0], dir)) {
            return false;
        }
        BlockCoord loc = this.getLocation().getLocation(dir);
        TileEntity te = this.field_145850_b.func_175625_s(loc.getBlockPos());
        return this.doPush(dir, te, 0, 0);
    }

    public static float getEnergyMultiplier(ICapacitorData capacitorType) {
        return CapacitorKey.STIRLING_POWER_GEN.get(capacitorType) / CapacitorKey.STIRLING_POWER_GEN.get(DefaultCapacitorData.BASIC_CAPACITOR);
    }

    public static float getBurnTimeMultiplier(ICapacitorData capacitorType) {
        return CapacitorKey.STIRLING_POWER_TIME.getFloat(capacitorType);
    }

    public float getBurnTimeMultiplier() {
        return TileEntityStirlingGenerator.getBurnTimeMultiplier(this.getCapacitorData());
    }

    private boolean transmitEnergy() {
        int canTransmit;
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(new BlockCoord((TileEntity)this));
        }
        if ((canTransmit = Math.min(this.getEnergyStored(), this.getPowerUsePerTick() * 2)) <= 0) {
            return false;
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, canTransmit);
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }
}

