/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.generator.zombie.BubbleFX;
import crazypants.enderio.machine.generator.zombie.ContainerZombieGenerator;
import crazypants.enderio.machine.generator.zombie.GuiZombieGenerator;
import crazypants.enderio.machine.generator.zombie.TileZombieGenerator;
import crazypants.enderio.machine.killera.KillerJoeRenderMapper;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.TextureRegistry;
import crazypants.enderio.sound.SoundHelper;
import crazypants.enderio.sound.SoundRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockZombieGenerator
extends AbstractMachineBlock<TileZombieGenerator> {
    public static final TextureRegistry.TextureSupplier textureHead1 = TextureRegistry.registerTexture("blocks/zombieGen_head");
    public static final TextureRegistry.TextureSupplier textureHead2 = TextureRegistry.registerTexture("blocks/zombieGen_head2");
    private static final Double px = 0.0625;
    public static final AxisAlignedBB AABB = new AxisAlignedBB(2.0 * px, 0.0 * px, 2.0 * px, 14.0 * px, 16.0 * px, 14.0 * px);

    public static BlockZombieGenerator create() {
        BlockZombieGenerator gen = new BlockZombieGenerator();
        gen.init();
        return gen;
    }

    protected BlockZombieGenerator() {
        super(ModObject.blockZombieGenerator, TileZombieGenerator.class, new Material(MapColor.field_151668_h){

            public boolean func_76218_k() {
                return false;
            }
        });
        this.func_149713_g(5);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerZombieGenerator(player.field_71071_by, (TileZombieGenerator)world.func_175625_s(new BlockPos(x, y, z)));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiZombieGenerator(player.field_71071_by, (TileZombieGenerator)world.func_175625_s(new BlockPos(x, y, z)));
    }

    @Override
    protected int getGuiId() {
        return 71;
    }

    public int func_149717_k(IBlockState bs) {
        return 0;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(IBlockState bs) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState bs, World world, BlockPos pos, Random rand) {
        TileEntity te;
        if (rand.nextInt(3) == 0 && (te = world.func_175625_s(pos)) instanceof TileZombieGenerator && ((TileZombieGenerator)te).isActive()) {
            for (int i = 0; i < 2; ++i) {
                float xOffset = 0.5f + (world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float yOffset = 0.1f;
                float zOffset = 0.5f + (world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.3f;
                BubbleFX fx = new BubbleFX(world, (float)pos.func_177958_n() + xOffset, (float)pos.func_177956_o() + yOffset, (float)pos.func_177952_p() + zOffset, 0.0, 0.5, 0.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
            }
            if (Config.machineSoundsEnabled) {
                SoundHelper.playSound(world, pos, SoundHelper.BLOCK_TOP, SoundRegistry.ZOMBIE_BUBBLE, Config.machineSoundVolume * 0.045f, world.field_73012_v.nextFloat() * 0.75f);
            }
        }
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te != null && te instanceof TileZombieGenerator) {
            tooltip.add(((TileZombieGenerator)te).getFluidStored(EnumFacing.NORTH) + " " + EnderIO.lang.localize("fluid.millibucket.abr"));
        }
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileZombieGenerator tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return KillerJoeRenderMapper.zombieGen;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return KillerJoeRenderMapper.zombieGen;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }
}

