/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.gui;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.util.Util;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class AbstractMachineContainer<T extends AbstractMachineEntity>
extends ContainerEnder<T> {
    protected Slot upgradeSlot;

    public AbstractMachineContainer(InventoryPlayer playerInv, T te) {
        super(playerInv, te);
    }

    protected void addSlots(InventoryPlayer playerInv) {
        this.addMachineSlots(playerInv);
        final AbstractMachineEntity te = (AbstractMachineEntity)this.getInv();
        if (te.getSlotDefinition().getNumUpgradeSlots() == 1) {
            this.upgradeSlot = new Slot((IInventory)te, te.getSlotDefinition().getMinUpgradeSlot(), this.getUpgradeOffset().x, this.getUpgradeOffset().y){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(@Nullable ItemStack itemStack) {
                    return te.func_94041_b(te.getSlotDefinition().getMinUpgradeSlot(), itemStack);
                }
            };
            this.func_75146_a(this.upgradeSlot);
        }
    }

    public Point getPlayerInventoryOffset() {
        return new Point(8, 84);
    }

    public Point getUpgradeOffset() {
        return new Point(12, 60);
    }

    public Slot getUpgradeSlot() {
        return this.upgradeSlot;
    }

    protected abstract void addMachineSlots(InventoryPlayer var1);

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slotNumber) {
        ItemStack origStack;
        SlotDefinition slotDef = ((AbstractMachineEntity)this.getInv()).getSlotDefinition();
        ItemStack copystack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotNumber);
        if (slot != null && slot.func_75216_d() && (origStack = slot.func_75211_c()) != null) {
            copystack = origStack.func_77946_l();
            boolean merged = false;
            for (SlotRange range : this.getTargetSlotsForTransfer(slotNumber, slot)) {
                if (!this.func_75135_a(origStack, range.getStart(), range.getEnd(), range.reverse)) continue;
                merged = true;
                break;
            }
            if (!merged) {
                return null;
            }
            if (slotDef.isOutputSlot(slot.getSlotIndex())) {
                slot.func_75220_a(origStack, copystack);
            }
            if (origStack.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (origStack.field_77994_a == copystack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(entityPlayer, origStack);
        }
        return copystack;
    }

    protected int getIndexOfFirstPlayerInvSlot(SlotDefinition slotDef) {
        return slotDef.getNumSlots();
    }

    protected SlotRange getPlayerInventorySlotRange(boolean reverse) {
        return new SlotRange(this.startPlayerSlot, this.endHotBarSlot, reverse);
    }

    protected SlotRange getPlayerInventoryWithoutHotbarSlotRange() {
        return new SlotRange(this.startPlayerSlot, this.endPlayerSlot, false);
    }

    protected SlotRange getPlayerHotbarSlotRange() {
        return new SlotRange(this.startHotBarSlot, this.endHotBarSlot, false);
    }

    protected void addInventorySlotRange(List<SlotRange> res, int start, int end) {
        for (int i = start; i < end; ++i) {
            Slot slotFromInventory = this.func_75147_a(this.getInv(), i);
            if (slotFromInventory == null) continue;
            int slotNumber = slotFromInventory.field_75222_d;
            res.add(new SlotRange(slotNumber, slotNumber + 1, false));
        }
    }

    protected void addInputSlotRanges(List<SlotRange> res) {
        SlotDefinition slotDef = ((AbstractMachineEntity)this.getInv()).getSlotDefinition();
        if (slotDef.getNumInputSlots() > 0) {
            this.addInventorySlotRange(res, slotDef.getMinInputSlot(), slotDef.getMaxInputSlot() + 1);
        }
    }

    protected void addUpgradeSlotRanges(List<SlotRange> res) {
        SlotDefinition slotDef = ((AbstractMachineEntity)this.getInv()).getSlotDefinition();
        if (slotDef.getNumUpgradeSlots() > 0) {
            this.addInventorySlotRange(res, slotDef.getMinUpgradeSlot(), slotDef.getMaxUpgradeSlot() + 1);
        }
    }

    protected void addPlayerSlotRanges(List<SlotRange> res, int slotIndex) {
        if (slotIndex < this.endPlayerSlot) {
            res.add(this.getPlayerHotbarSlotRange());
        }
        if (slotIndex >= this.startHotBarSlot && slotIndex < this.endHotBarSlot) {
            res.add(this.getPlayerInventoryWithoutHotbarSlotRange());
        }
    }

    protected List<SlotRange> getTargetSlotsForTransfer(int slotNumber, Slot slot) {
        if (slot.field_75224_c == this.getInv()) {
            SlotDefinition slotDef = ((AbstractMachineEntity)this.getInv()).getSlotDefinition();
            if (slotDef.isInputSlot(slot.getSlotIndex()) || slotDef.isUpgradeSlot(slot.getSlotIndex())) {
                return Collections.singletonList(this.getPlayerInventorySlotRange(false));
            }
            if (slotDef.isOutputSlot(slot.getSlotIndex())) {
                return Collections.singletonList(this.getPlayerInventorySlotRange(true));
            }
        } else if (slotNumber >= this.startPlayerSlot) {
            ArrayList<SlotRange> res = new ArrayList<SlotRange>();
            this.addInputSlotRanges(res);
            this.addUpgradeSlotRanges(res);
            this.addPlayerSlotRanges(res, slotNumber);
            return res;
        }
        return Collections.emptyList();
    }

    protected int getProgressScaled(int scale) {
        if (this.getInv() instanceof IProgressTile) {
            Util.getProgressScaled((int)scale, (IProgressTile)((IProgressTile)this.getInv()));
        }
        return 0;
    }

    public static class SlotRange {
        private final int start;
        private final int end;
        final boolean reverse;

        public SlotRange(int start, int end, boolean reverse) {
            this.start = start;
            this.end = end;
            this.reverse = reverse;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

