/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.MachineRenderMapper;
import crazypants.enderio.render.EnumRenderMode6;
import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.pipeline.ItemQuadCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class InvPanelRenderMapper
extends MachineRenderMapper {
    public static final MachineRenderMapper instance = new InvPanelRenderMapper();

    public InvPanelRenderMapper() {
        super(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected List<IBlockState> render(IBlockState state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, AbstractMachineEntity tileEntity, AbstractMachineBlock<?> block) {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        EnumFacing facing = tileEntity.getFacing();
        boolean active = tileEntity.isActive();
        if (active) {
            states.add(state.func_177226_a(EnumRenderMode6.RENDER, (Comparable)((Object)EnumRenderMode6.FRONT_ON.rotate(facing))));
        } else {
            states.add(state.func_177226_a(EnumRenderMode6.RENDER, (Comparable)((Object)EnumRenderMode6.FRONT.rotate(facing))));
        }
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected EnumMap<EnumFacing, IOMode.EnumIOMode> renderIO(@Nonnull AbstractMachineEntity tileEntity, @Nonnull AbstractMachineBlock<?> block) {
        EnumMap<EnumFacing, IOMode.EnumIOMode> result = new EnumMap<EnumFacing, IOMode.EnumIOMode>(EnumFacing.class);
        EnumFacing face = tileEntity.getFacing().func_176734_d();
        IoMode ioMode = tileEntity.getIoMode(face);
        if (ioMode != IoMode.NONE) {
            result.put(face, block.mapIOMode(ioMode, face));
            return result;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<Pair<IBlockState, ItemStack>> mapItemRender(Block block, ItemStack stack, ItemQuadCollector itemQuadCollector) {
        return Collections.singletonList(Pair.of((Object)block.func_176203_a(stack.func_77960_j()).func_177226_a(EnumRenderMode6.RENDER, (Comparable)((Object)EnumRenderMode6.FRONT_ON_NORTH)), (Object)stack));
    }
}

