/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.light;

import com.enderio.core.common.vecmath.Vector3f;
import crazypants.enderio.BlockEio;
import crazypants.enderio.IHaveRenderers;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.machine.light.BlockItemElectricLight;
import crazypants.enderio.machine.light.LightType;
import crazypants.enderio.machine.light.TileElectricLight;
import crazypants.util.ClientUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockElectricLight
extends BlockEio<TileElectricLight>
implements IRedstoneConnectable,
IHaveRenderers {
    static final float BLOCK_HEIGHT = 0.05f;
    static final float BLOCK_WIDTH = 0.3f;
    static final float BLOCK_EDGE_MAX = 0.65f;
    static final float BLOCK_EDGE_MIN = 0.35f;
    public static final PropertyEnum<LightType> TYPE = PropertyEnum.func_177709_a((String)"type", LightType.class);
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"face", EnumFacing.class);

    public static BlockElectricLight create() {
        BlockElectricLight result = new BlockElectricLight();
        result.init();
        return result;
    }

    public BlockElectricLight() {
        super(ModObject.blockElectricLight.getUnlocalisedName(), TileElectricLight.class);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)LightType.ELECTRIC)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a(FACING, (Comparable)EnumFacing.DOWN));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing onFace = EnumFacing.DOWN;
        TileEntity te = source.func_175625_s(pos);
        if (te instanceof TileElectricLight) {
            onFace = ((TileElectricLight)te).getFace();
        }
        Vector3f min = new Vector3f();
        Vector3f max = new Vector3f();
        switch (onFace) {
            case UP: {
                min.set(0.35f, 0.95f, 0.35f);
                max.set(0.65f, 1.0f, 0.65f);
                break;
            }
            case DOWN: {
                min.set(0.35f, 0.0f, 0.35f);
                max.set(0.65f, 0.05f, 0.65f);
                break;
            }
            case EAST: {
                min.set(0.95f, 0.35f, 0.35f);
                max.set(1.0f, 0.65f, 0.65f);
                break;
            }
            case WEST: {
                min.set(0.0f, 0.35f, 0.35f);
                max.set(0.05f, 0.65f, 0.65f);
                break;
            }
            case NORTH: {
                min.set(0.35f, 0.35f, 0.0f);
                max.set(0.65f, 0.65f, 0.05f);
                break;
            }
            case SOUTH: {
                min.set(0.35f, 0.35f, 0.95f);
                max.set(0.65f, 0.65f, 1.0f);
                break;
            }
            default: {
                min.set(0.35f, 0.0f, 0.35f);
                max.set(0.65f, 0.05f, 0.65f);
            }
        }
        return new AxisAlignedBB((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    protected ItemBlock createItemBlock() {
        return new BlockItemElectricLight((Block)this, this.getName());
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, ACTIVE, FACING});
    }

    public int func_176201_c(IBlockState state) {
        boolean active = (Boolean)state.func_177229_b((IProperty)ACTIVE);
        int type = ((LightType)((Object)state.func_177229_b(TYPE))).getMetadata();
        if (active) {
            type |= 8;
        }
        return type;
    }

    public IBlockState func_176203_a(int meta) {
        LightType type = LightType.fromMetadata(meta);
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(meta > 7));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileElectricLight te = (TileElectricLight)this.getTileEntity(world, pos);
        return state.func_177226_a(FACING, (Comparable)(te == null ? EnumFacing.DOWN : te.getFace()));
    }

    public int func_180651_a(IBlockState state) {
        return ((LightType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        Item item = Item.func_150898_a((Block)this);
        int numTypes = LightType.values().length;
        for (int i = 0; i < numTypes; ++i) {
            ClientUtil.regRenderer(item, i, this.name);
        }
    }

    public int getLightValue(IBlockState bs, IBlockAccess world, BlockPos pos) {
        Block block = bs.func_177230_c();
        if (block != null && block != this) {
            return block.getLightValue(bs, world, pos);
        }
        return (Boolean)bs.func_177229_b((IProperty)ACTIVE) != false ? 15 : 0;
    }

    @Override
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, EnumFacing from) {
        return true;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(IBlockState bs) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        TileElectricLight te = (TileElectricLight)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te != null) {
            te.onNeighborBlockChange(neighborBlock);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileElectricLight te = (TileElectricLight)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te != null) {
            te.onBlockRemoved();
        }
    }

    public boolean doNormalDrops(IBlockAccess world, BlockPos pos) {
        return true;
    }
}

