/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.tank.BlockItemTank;
import crazypants.enderio.machine.tank.ContainerTank;
import crazypants.enderio.machine.tank.EnumTankType;
import crazypants.enderio.machine.tank.GuiTank;
import crazypants.enderio.machine.tank.PacketTankFluid;
import crazypants.enderio.machine.tank.PacketTankVoidMode;
import crazypants.enderio.machine.tank.TankItemRenderMapper;
import crazypants.enderio.machine.tank.TileTank;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.EnumRenderMode;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTank
extends AbstractMachineBlock<TileTank>
implements IAdvancedTooltipProvider,
IPaintable.INonSolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockTank create() {
        PacketHandler.INSTANCE.registerMessage(PacketTankFluid.class, PacketTankFluid.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketTankVoidMode.class, PacketTankVoidMode.class, PacketHandler.nextID(), Side.SERVER);
        BlockTank res = new BlockTank();
        res.init();
        return res;
    }

    protected BlockTank() {
        super(ModObject.blockTank, TileTank.class);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)).func_177226_a(EnumTankType.KIND, (Comparable)((Object)EnumTankType.NORMAL)));
    }

    protected ItemBlock createItemBlock() {
        return new BlockItemTank((Block)this, this.name);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER, EnumTankType.KIND});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(EnumTankType.KIND, (Comparable)((Object)EnumTankType.getTypeFromMeta(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return EnumTankType.getMetaFromType((EnumTankType)((Object)state.func_177229_b(EnumTankType.KIND)));
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO));
    }

    public int func_180651_a(IBlockState st) {
        return this.func_176201_c(st);
    }

    public TileEntity createTileEntity(World world, IBlockState bs) {
        return new TileTank(this.func_176201_c(bs));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState bs, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileTank)) {
            return null;
        }
        return new ContainerTank(player.field_71071_by, (TileTank)te);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileTank)) {
            return null;
        }
        return new GuiTank(player.field_71071_by, (TileTank)te);
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    @Override
    protected int getGuiId() {
        return 86;
    }

    public int getLightValue(IBlockState bs, IBlockAccess world, BlockPos pos) {
        TileEntity tank = world.func_175625_s(pos);
        if (tank instanceof TileTank) {
            FluidStack stack = ((TileTank)tank).tank.getFluid();
            return stack == null || stack.amount <= 0 ? 0 : stack.getFluid().getLuminosity(stack);
        }
        return super.getLightValue(bs, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity par1Entity, Explosion explosion) {
        IBlockState bs = world.func_180495_p(pos);
        int meta = this.func_176201_c(bs);
        if ((meta = MathHelper.func_76125_a((int)meta, (int)0, (int)1)) == 1) {
            return 1200.0f;
        }
        return super.func_149638_a(par1Entity);
    }

    public boolean func_149740_M(IBlockState bs) {
        return true;
    }

    public int func_180641_l(IBlockState bs, World w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        if (te instanceof TileTank) {
            return ((TileTank)te).getComparatorOutput();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        FluidStack fl;
        if (itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74764_b("tankContents") && (fl = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)itemstack.func_77978_p().func_74781_a("tankContents")))) != null && fl.getFluid() != null) {
            String str = fl.amount + " " + EnderIO.lang.localize("fluid.millibucket.abr") + " " + PowerDisplayUtil.ofStr() + " " + fl.getFluid().getName();
            list.add(str);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (ItemStack)itemstack);
        if (itemstack.func_77952_i() == 1) {
            list.add(TextFormatting.ITALIC + EnderIO.lang.localize("blastResistant"));
        }
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return stack.func_77977_a();
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileTank) {
            TileTank tank = (TileTank)te;
            FluidStack stored = tank.tank.getFluid();
            String fluid = stored == null ? EnderIO.lang.localize("tooltip.none") : stored.getFluid().getLocalizedName(stored);
            int amount = stored == null ? 0 : stored.amount;
            tooltip.add(String.format("%s%s : %s (%d %s)", TextFormatting.WHITE, EnderIO.lang.localize("tooltip.fluidStored"), fluid, amount, EnderIO.lang.localize("fluid.millibucket.abr")));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return TankItemRenderMapper.instance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return TankItemRenderMapper.instance;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileTank tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(blockStateWrapper.func_177229_b((IProperty)EnumTankType.KIND));
    }
}

