/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render;

import com.enderio.core.client.render.RenderUtil;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Timer;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class RotatingSmartItemModel
implements IPerspectiveAwareModel {
    private final IPerspectiveAwareModel parent;
    private final int speed;
    private final ItemOverrideList overrides = new ItemOverrideList(Lists.newArrayList()){

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (originalModel != RotatingSmartItemModel.this) {
                return originalModel;
            }
            if (RotatingSmartItemModel.this.parent != null) {
                IBakedModel newBase = RotatingSmartItemModel.this.parent.func_188617_f().handleItemState((IBakedModel)RotatingSmartItemModel.this.parent, stack, world, entity);
                if (RotatingSmartItemModel.this.parent != newBase && newBase instanceof IPerspectiveAwareModel) {
                    return new RotatingSmartItemModel((IPerspectiveAwareModel)newBase, RotatingSmartItemModel.this.speed);
                }
            }
            return RotatingSmartItemModel.this;
        }
    };

    public RotatingSmartItemModel(IPerspectiveAwareModel parent, int speed) {
        this.parent = parent;
        this.speed = speed;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.parent.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair perspective = this.parent.handlePerspective(cameraTransformType);
        Timer timer = RenderUtil.getTimer();
        double r = (float)(EnderIO.proxy.getTickCount() % 360L) + (timer == null ? 0.0f : timer.field_74281_c);
        TRSRTransformation transformOrig = new TRSRTransformation((Matrix4f)perspective.getRight());
        Quat4f leftRot = transformOrig.getLeftRot();
        Quat4f yRotation = new Quat4f();
        yRotation.set(new AxisAngle4d(0.0, 1.0, 0.0, Math.toRadians(r * (double)this.speed)));
        leftRot.mul(yRotation);
        TRSRTransformation transformNew = new TRSRTransformation(transformOrig.getTranslation(), leftRot, transformOrig.getScale(), transformOrig.getRightRot());
        return Pair.of((Object)perspective.getLeft(), (Object)transformNew.getMatrix());
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }
}

