/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import crazypants.enderio.render.pipeline.CompositeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemQuadCollector {
    private final List<BakedQuad>[] table = new List[EnumFacing.values().length + 1];

    private static Integer facing2Integer(EnumFacing facing) {
        return facing == null ? EnumFacing.values().length : facing.ordinal();
    }

    public void addQuads(EnumFacing side, List<BakedQuad> quads) {
        if (quads != null && !quads.isEmpty()) {
            Integer face = ItemQuadCollector.facing2Integer(side);
            List<BakedQuad> list = this.table[face];
            if (list == null) {
                this.table[face.intValue()] = new ArrayList<BakedQuad>(quads);
            } else {
                list.addAll(quads);
            }
        }
    }

    public List<BakedQuad> getQuads(EnumFacing side) {
        Integer face = ItemQuadCollector.facing2Integer(side);
        if (this.table[face] == null) {
            return Collections.emptyList();
        }
        return this.table[face];
    }

    public void addBlockStates(List<Pair<IBlockState, ItemStack>> states, ItemStack parent, Block parentBlock) {
        if (states == null || states.isEmpty()) {
            return;
        }
        BlockModelShapes modelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        for (Pair<IBlockState, ItemStack> pair : states) {
            IBlockState state = (IBlockState)pair.getLeft();
            if (state == null) continue;
            ItemStack stack = (ItemStack)pair.getRight();
            if (stack == null) {
                stack = state.func_177230_c() == parentBlock ? parent : new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
            }
            IBakedModel model = modelShapes.func_178125_b(state);
            this.addBakedModel(model, stack);
        }
    }

    public void addItemBlockStates(List<Pair<IBlockState, ItemStack>> states, ItemStack parent, Block parentBlock) {
        if (states == null || states.isEmpty()) {
            return;
        }
        for (Pair<IBlockState, ItemStack> pair : states) {
            IBlockState state = (IBlockState)pair.getLeft();
            if (state == null) continue;
            ItemStack stack = (ItemStack)pair.getRight();
            if (stack == null) {
                stack = state.func_177230_c() == parentBlock ? parent : new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
            }
            this.addItemModel(stack);
        }
    }

    public void addBlockState(IBlockState state, ItemStack stack) {
        this.addBlockState(state, stack, false);
    }

    public void addBlockState(IBlockState state, ItemStack stack, boolean allFacesToGeneral) {
        if (state != null) {
            if (stack == null) {
                stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
            }
            BlockModelShapes modelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
            IBakedModel model = modelShapes.func_178125_b(state);
            this.addBakedModel(model, stack, allFacesToGeneral);
        }
    }

    public void addItemBlockState(IBlockState state, ItemStack stack) {
        if (state != null) {
            if (stack == null) {
                stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
            }
            this.addItemModel(stack);
        }
    }

    public void addItemModel(ItemStack stack) {
        if (stack != null && stack.func_77973_b() != null) {
            this.addItemBakedModel(Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null));
        }
    }

    public void addBakedModel(IBakedModel model, ItemStack stack) {
        this.addBakedModel(model, stack, false);
    }

    public void addBakedModel(IBakedModel model, ItemStack stack, boolean allFacesToGeneral) {
        if ((model = model.func_188617_f().handleItemState(model, stack, (World)null, (EntityLivingBase)null)) == null) {
            model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a();
        }
        this.addItemBakedModel(model, allFacesToGeneral);
    }

    public void addItemBakedModel(IBakedModel model) {
        this.addItemBakedModel(model, false);
    }

    public void addItemBakedModel(IBakedModel model, boolean allFacesToGeneral) {
        List generalQuads = model.func_188616_a((IBlockState)null, (EnumFacing)null, 0L);
        if (generalQuads != null && !generalQuads.isEmpty()) {
            this.addQuads(null, generalQuads);
        }
        for (EnumFacing face : EnumFacing.values()) {
            List faceQuads = model.func_188616_a((IBlockState)null, face, 0L);
            if (faceQuads == null || faceQuads.isEmpty()) continue;
            this.addQuads(allFacesToGeneral ? null : face, faceQuads);
        }
    }

    public boolean isEmpty() {
        for (List<BakedQuad> entry : this.table) {
            if (entry == null || entry.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemQuadCollector combine(@Nullable ItemQuadCollector other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        ItemQuadCollector result = new ItemQuadCollector();
        for (int i = 0; i < this.table.length; ++i) {
            result.table[i] = CompositeList.create(this.table[i], other.table[i]);
        }
        return result;
    }
}

