/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.teleport.telepad.TileTelePad;
import java.util.List;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ItemCoordSelector
extends Item
implements IResourceTooltipProvider {
    public static ItemCoordSelector create() {
        ItemCoordSelector ret = new ItemCoordSelector();
        GameRegistry.register((IForgeRegistryEntry)ret);
        return ret;
    }

    private ItemCoordSelector() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.setRegistryName(ModObject.itemCoordSelector.name());
        this.func_77625_d(1);
    }

    public void func_150895_a(Item item, CreativeTabs p_150895_2_, List list) {
        ItemStack stack = new ItemStack(item);
        ItemCoordSelector.init(stack);
        list.add(stack);
    }

    public static void init(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        new BlockCoord().writeToNBT(stack.func_77978_p());
        stack.func_77978_p().func_74757_a("default", true);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        if (stack != null && stack.func_77978_p() != null && !stack.func_77978_p().func_74767_n("default")) {
            list.add(this.getCoords(stack).chatString(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, player, list, p_77624_4_);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (this.rayTraceCoords(stack, world, player)) {
            player.func_184609_a(hand);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!this.rayTraceCoords(stack, world, player)) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITelePad) {
            ITelePad tp = (ITelePad)te;
            TileTelePad tile = null;
            if (te instanceof TileTelePad) {
                tile = (TileTelePad)te;
            }
            if (tp.canBlockBeAccessed(player)) {
                BlockCoord bc = this.getCoords(stack);
                BlockCoord cur = new BlockCoord(tp.getX(), tp.getY(), tp.getZ());
                int dim = this.getDimension(stack);
                int curDim = tp.getTargetDim();
                if (!bc.equals((Object)cur)) {
                    if (tile != null) {
                        tile.setCoords_internal(bc);
                    } else {
                        tp.setCoords(bc);
                    }
                    if (!world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemCoordSelector.chat.setCoords", new Object[]{bc.chatString()})));
                    }
                }
                if (dim != curDim) {
                    if (tile != null) {
                        tile.setTargetDim_internal(dim);
                    } else {
                        tp.setTargetDim(dim);
                    }
                    if (!world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemCoordSelector.chat.setDimension", new Object[]{TextFormatting.GREEN.toString(), Integer.toString(dim)})));
                    }
                }
                if (bc.equals((Object)cur) && dim == curDim) {
                    return EnumActionResult.PASS;
                }
            } else {
                BlockTravelAnchor.sendPrivateChatMessage(player, tp.getOwner());
            }
        }
        if (world.field_72995_K) {
            this.sendItemUsePacket(stack, player, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side.ordinal(), hitX, hitY, hitZ);
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean rayTraceCoords(ItemStack stack, World world, EntityPlayer player) {
        Vector3d headVec = Util.getEyePositionEio((EntityPlayer)player);
        Vec3d start = headVec.getVec3();
        Vec3d lookVec = player.func_70676_i(1.0f);
        double reach = 500.0;
        headVec.add(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        RayTraceResult mop = world.func_72933_a(start, headVec.getVec3());
        if (mop == null) {
            return false;
        }
        BlockCoord bc = new BlockCoord(mop);
        BlockCoord onStack = this.getCoords(stack);
        TileEntity te = bc.getTileEntity((IBlockAccess)world);
        if (te instanceof ITelePad) {
            return true;
        }
        if (!player.func_70093_af()) {
            EnumFacing dir = mop.field_178784_b;
            bc = bc.getLocation(dir);
        }
        int dim = world.field_73011_w.getDimension();
        int curDim = this.getDimension(stack);
        boolean changed = false;
        if (!bc.equals((Object)onStack)) {
            this.setCoords(stack, bc);
            this.onCoordsChanged(player, bc);
            changed = true;
        }
        if (dim != curDim) {
            this.setDimension(stack, world);
            this.onDimensionChanged(player, this.getDimension(stack));
            changed = true;
        }
        return changed;
    }

    private void sendItemUsePacket(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        NetHandlerPlayClient netClientHandler = (NetHandlerPlayClient)FMLClientHandler.instance().getClientPlayHandler();
        CPacketPlayerTryUseItem packet = new CPacketPlayerTryUseItem(EnumHand.MAIN_HAND);
        netClientHandler.func_147297_a((Packet)packet);
    }

    private void onCoordsChanged(EntityPlayer player, BlockCoord bc) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemCoordSelector.chat.newCoords", new Object[]{bc.chatString()})));
        }
    }

    private void onDimensionChanged(EntityPlayer player, int dim) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemCoordSelector.chat.newDimension", new Object[]{TextFormatting.GREEN.toString(), Integer.toString(dim)})));
        }
    }

    public void setCoords(ItemStack stack, BlockCoord bc) {
        stack.func_77978_p().func_74757_a("default", false);
        bc.writeToNBT(stack.func_77978_p());
    }

    public void setDimension(ItemStack stack, World world) {
        stack.func_77978_p().func_74768_a("dimension", world.field_73011_w.getDimension());
    }

    public BlockCoord getCoords(ItemStack stack) {
        return BlockCoord.readFromNBT((NBTTagCompound)stack.func_77978_p());
    }

    public int getDimension(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("dimension");
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_77658_a();
    }
}

