/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import com.enderio.core.common.BlockEnder;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.PacketFluidLevel;
import crazypants.enderio.machine.generator.combustion.PacketCombustionTank;
import crazypants.enderio.machine.generator.combustion.TileCombustionGenerator;
import crazypants.enderio.machine.generator.stirling.PacketBurnTime;
import crazypants.enderio.machine.generator.stirling.TileEntityStirlingGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.ModelLoader;

public class ClientUtil {
    private static final Random rand = new Random();

    public static void doFluidLevelUpdate(int x, int y, int z, PacketFluidLevel pkt) {
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(x, y, z));
        if (pkt.tc == null || !(tile instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle bundle = (IConduitBundle)tile;
        ILiquidConduit con = bundle.getConduit(ILiquidConduit.class);
        if (con == null) {
            return;
        }
        con.readFromNBT(pkt.tc, (short)1);
    }

    public static void spawnFarmParcticles(Random rand, BlockPos bc) {
        double xOff = 0.5 + (rand.nextDouble() - 0.5) * 1.1;
        double yOff = 0.5 + (rand.nextDouble() - 0.5) * 0.2;
        double zOff = 0.5 + (rand.nextDouble() - 0.5) * 1.1;
        Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.PORTAL, (double)bc.func_177958_n() + xOff, (double)bc.func_177956_o() + yOff, (double)bc.func_177952_p() + zOff, (rand.nextDouble() - 0.5) * 1.5, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 1.5, new int[0]);
    }

    public static void setTankNBT(PacketCombustionTank message, BlockPos pos) {
        NBTTagCompound tankRoot;
        TileCombustionGenerator tile = (TileCombustionGenerator)Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
        if (tile == null) {
            return;
        }
        if (message.nbtRoot.func_74764_b("coolantTank")) {
            tankRoot = message.nbtRoot.func_74775_l("coolantTank");
            tile.getCoolantTank().readFromNBT(tankRoot);
        } else {
            tile.getCoolantTank().setFluid(null);
        }
        if (message.nbtRoot.func_74764_b("fuelTank")) {
            tankRoot = message.nbtRoot.func_74775_l("fuelTank");
            tile.getFuelTank().readFromNBT(tankRoot);
        } else {
            tile.getFuelTank().setFluid(null);
        }
    }

    public static void setStirlingBurnTime(PacketBurnTime message, int x, int y, int z) {
        TileEntityStirlingGenerator tile = (TileEntityStirlingGenerator)Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(x, y, z));
        if (tile == null) {
            return;
        }
        tile.burnTime = message.burnTime;
        tile.totalBurnTime = message.totalBurnTime;
    }

    public static void regRenderer(Block block, int meta, String name) {
        Item item = Item.func_150898_a((Block)block);
        ResourceLocation resourceLocation = block.getRegistryName();
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(resourceLocation, name);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }

    public static void regRenderer(Item item, int meta, String name) {
        ClientUtil.regRenderer(item, meta, EnderIO.DOMAIN, name);
    }

    public static void regRenderer(Item item, int meta, String modId, String name) {
        String resourceName = modId != null ? modId + ":" + name : name;
        ClientUtil.regRenderer(item, meta, new ResourceLocation(resourceName));
    }

    public static void regRenderer(Item item, int meta, ResourceLocation loc) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
    }

    public static void registerDefaultItemRenderer(BlockEnder<?> block) {
        if (block == null) {
            return;
        }
        ClientUtil.regRenderer(Item.func_150898_a(block), 0, block.getName());
    }

    public static void registerRenderer(Item item, String name) {
        ClientUtil.regRenderer(item, 0, name);
    }

    public static void spawnParcticles(double posX, double posY, double posZ, int count, EnumParticleTypes particle) {
        for (int i = 0; i < count; ++i) {
            double d2;
            double d1;
            double d0;
            double zOff;
            double yOff;
            double xOff;
            if (particle == EnumParticleTypes.PORTAL) {
                xOff = (rand.nextDouble() - 0.5) * 1.1;
                yOff = (rand.nextDouble() - 0.5) * 1.1;
                zOff = (rand.nextDouble() - 0.5) * 1.1;
                d0 = (rand.nextDouble() - 0.5) * 1.5;
                d1 = -rand.nextDouble();
                d2 = (rand.nextDouble() - 0.5) * 1.5;
            } else if (particle == EnumParticleTypes.DAMAGE_INDICATOR) {
                xOff = 0.1;
                yOff = 0.0;
                zOff = 0.1;
                d2 = 0.2;
                d1 = 0.2;
                d0 = 0.2;
            } else {
                zOff = 0.0;
                yOff = 0.0;
                xOff = 0.0;
                d0 = rand.nextGaussian() * 0.02;
                d1 = rand.nextGaussian() * 0.02;
                d2 = rand.nextGaussian() * 0.02;
            }
            Minecraft.func_71410_x().field_71441_e.func_175688_a(particle, posX + xOff, posY + yOff, posZ + zOff, d0, d1, d2, new int[0]);
        }
    }
}

