/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HandleArrayList<E>
implements IHandler<List<E>> {
    private final IHandler<E> elemHandler;

    protected HandleArrayList(IHandler<E> elemHandler) {
        this.elemHandler = elemHandler;
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull List<E> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("size", object.size());
        for (int i = 0; i < object.size(); ++i) {
            E elem = object.get(i);
            if (elem == null) continue;
            this.elemHandler.store(registry, phase, tag, i + "", elem);
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return true;
    }

    @Override
    public List<E> read(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nullable List<E> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            if (object == null) {
                object = new ArrayList();
            } else {
                object.clear();
            }
            NBTTagCompound tag = nbt.func_74775_l(name);
            int size = tag.func_74762_e("size");
            for (int i = 0; i < size; ++i) {
                if (tag.func_74764_b(i + "")) {
                    object.add(this.elemHandler.read(registry, phase, tag, i + "", null));
                    continue;
                }
                object.add(null);
            }
        }
        return object;
    }
}

