/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.handlers.ClientHandler;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.VertexTranslation;
import com.enderio.core.common.util.Log;
import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector2f;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vector4d;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Timer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static final Vector4f DEFAULT_TEXT_SHADOW_COL = new Vector4f(0.33f, 0.33f, 0.33f, 0.33f);
    public static final Vector4f DEFAULT_TXT_COL = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Vector4f DEFAULT_TEXT_BG_COL = new Vector4f(0.275f, 0.08f, 0.4f, 0.75f);
    public static final Vector3d UP_V = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d ZERO_V = new Vector3d(0.0, 0.0, 0.0);
    private static final FloatBuffer MATRIX_BUFFER = GLAllocation.func_74529_h((int)16);
    public static final ResourceLocation BLOCK_TEX = TextureMap.field_110575_b;
    public static final ResourceLocation GLINT_TEX = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static int BRIGHTNESS_MAX = 0xF000F0;
    private static Field timerField = RenderUtil.initTimer();

    public static void loadMatrix(Matrix4d mat) {
        MATRIX_BUFFER.rewind();
        MATRIX_BUFFER.put((float)mat.m00);
        MATRIX_BUFFER.put((float)mat.m01);
        MATRIX_BUFFER.put((float)mat.m02);
        MATRIX_BUFFER.put((float)mat.m03);
        MATRIX_BUFFER.put((float)mat.m10);
        MATRIX_BUFFER.put((float)mat.m11);
        MATRIX_BUFFER.put((float)mat.m12);
        MATRIX_BUFFER.put((float)mat.m13);
        MATRIX_BUFFER.put((float)mat.m20);
        MATRIX_BUFFER.put((float)mat.m21);
        MATRIX_BUFFER.put((float)mat.m22);
        MATRIX_BUFFER.put((float)mat.m23);
        MATRIX_BUFFER.put((float)mat.m30);
        MATRIX_BUFFER.put((float)mat.m31);
        MATRIX_BUFFER.put((float)mat.m32);
        MATRIX_BUFFER.put((float)mat.m33);
        MATRIX_BUFFER.rewind();
        GL11.glLoadMatrix((FloatBuffer)MATRIX_BUFFER);
    }

    private static Field initTimer() {
        Field f = null;
        try {
            f = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"field_71428_T", "timer", "Q"});
            f.setAccessible(true);
        }
        catch (Exception e) {
            Log.error("Failed to initialize timer reflection for IO config.");
            e.printStackTrace();
        }
        return f;
    }

    @Nullable
    public static Timer getTimer() {
        if (timerField == null) {
            return null;
        }
        try {
            return (Timer)timerField.get(Minecraft.func_71410_x());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TextureManager engine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static void bindBlockTexture() {
        RenderUtil.engine().func_110577_a(BLOCK_TEX);
    }

    public static void bindGlintTexture() {
        RenderUtil.engine().func_110577_a(BLOCK_TEX);
    }

    public static void bindTexture(String string) {
        RenderUtil.engine().func_110577_a(new ResourceLocation(string));
    }

    public static void bindTexture(ResourceLocation tex) {
        RenderUtil.engine().func_110577_a(tex);
    }

    public static FontRenderer fontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static float[] getDefaultPerSideBrightness() {
        float[] brightnessPerSide = new float[6];
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            brightnessPerSide[dir.ordinal()] = RenderUtil.getColorMultiplierForFace(dir);
        }
        return brightnessPerSide;
    }

    public static float claculateTotalBrightnessForLocation(World worldObj, BlockPos pos) {
        return RenderUtil.claculateTotalBrightnessForLocation(worldObj, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static float claculateTotalBrightnessForLocation(World worldObj, int xCoord, int yCoord, int zCoord) {
        int i = worldObj.func_175705_a(EnumSkyBlock.SKY, new BlockPos(xCoord, yCoord, zCoord));
        int j = i % 65536;
        int k = i / 65536;
        float sunBrightness = worldObj.func_72971_b(1.0f);
        float percentRecievedFromSun = (float)k / 255.0f;
        float fromLights = (float)j / 255.0f;
        float highestValue = Math.max(fromLights, percentRecievedFromSun * sunBrightness);
        return Math.max(0.2f, highestValue);
    }

    public static float getColorMultiplierForFace(EnumFacing face) {
        if (face == EnumFacing.UP) {
            return 1.0f;
        }
        if (face == EnumFacing.DOWN) {
            return 0.5f;
        }
        if (face.func_82601_c() != 0) {
            return 0.6f;
        }
        return 0.8f;
    }

    public static void renderQuad2D(double x, double y, double z, double width, double height, int colorRGB) {
        GlStateManager.func_179090_x();
        Vector3f col = ColorUtil.toFloat(colorRGB);
        GlStateManager.func_179124_c((float)col.x, (float)col.y, (float)col.z);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer tes = tessellator.func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tes.func_181662_b(x, y + height, z).func_181675_d();
        tes.func_181662_b(x + width, y + height, z).func_181675_d();
        tes.func_181662_b(x + width, y, z).func_181675_d();
        tes.func_181662_b(x, y, z).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static void renderQuad2D(double x, double y, double z, double width, double height, Vector4f colorRGBA) {
        GlStateManager.func_179131_c((float)colorRGBA.x, (float)colorRGBA.y, (float)colorRGBA.z, (float)colorRGBA.w);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer tes = tessellator.func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tes.func_181662_b(x, y + height, z).func_181675_d();
        tes.func_181662_b(x + width, y + height, z).func_181675_d();
        tes.func_181662_b(x + width, y, z).func_181675_d();
        tes.func_181662_b(x, y, z).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static Matrix4d createBillboardMatrix(TileEntity te, EntityLivingBase entityPlayer) {
        BlockPos p = te.func_174877_v();
        return RenderUtil.createBillboardMatrix(new Vector3d((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5), entityPlayer);
    }

    public static Matrix4d createBillboardMatrix(Vector3d lookAt, EntityLivingBase entityPlayer) {
        Vector3d playerEye = new Vector3d(entityPlayer.field_70165_t, entityPlayer.field_70163_u + 1.62 - entityPlayer.func_70033_W(), entityPlayer.field_70161_v);
        Vector3d blockOrigin = new Vector3d(lookAt.x, lookAt.y, lookAt.z);
        Matrix4d lookMat = VecmathUtil.createMatrixAsLookAt(blockOrigin, playerEye, UP_V);
        lookMat.setTranslation(new Vector3d());
        lookMat.invert();
        return lookMat;
    }

    public static void renderBillboard(Matrix4d lookMat, float minU, float maxU, float minV, float maxV, double size, int brightness) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer tes = tessellator.func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double s = size / 2.0;
        Vector3d v = new Vector3d();
        v.set(-s, s, 0.0);
        lookMat.transform(v);
        tes.func_181662_b(v.x, v.y, v.z).func_187315_a((double)minU, (double)maxV).func_181675_d();
        v.set(s, s, 0.0);
        lookMat.transform(v);
        tes.func_181662_b(v.x, v.y, v.z).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        v.set(s, -s, 0.0);
        lookMat.transform(v);
        tes.func_181662_b(v.x, v.y, v.z).func_187315_a((double)maxU, (double)minV).func_181675_d();
        v.set(-s, -s, 0.0);
        lookMat.transform(v);
        tes.func_181662_b(v.x, v.y, v.z).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static List<EnumFacing> getEdgesForFace(EnumFacing face) {
        ArrayList<EnumFacing> result = new ArrayList<EnumFacing>(4);
        if (face.func_96559_d() != 0) {
            result.add(EnumFacing.NORTH);
            result.add(EnumFacing.EAST);
            result.add(EnumFacing.SOUTH);
            result.add(EnumFacing.WEST);
        } else if (face.func_82601_c() != 0) {
            result.add(EnumFacing.DOWN);
            result.add(EnumFacing.SOUTH);
            result.add(EnumFacing.UP);
            result.add(EnumFacing.NORTH);
        } else {
            result.add(EnumFacing.DOWN);
            result.add(EnumFacing.WEST);
            result.add(EnumFacing.UP);
            result.add(EnumFacing.EAST);
        }
        return result;
    }

    public static void addVerticesToTessellator(List<Vertex> vertices, VertexFormat format, boolean doBegin) {
        RenderUtil.addVerticesToTessellator(vertices, null, format, doBegin);
    }

    public static void addVerticesToTessellator(List<Vertex> vertices, VertexTranslation xForm, VertexFormat format, boolean doBegin) {
        if (vertices == null || vertices.isEmpty()) {
            return;
        }
        if (xForm != null) {
            ArrayList<Vertex> newV = new ArrayList<Vertex>(vertices.size());
            for (Vertex v : vertices) {
                Vertex xv = new Vertex(v);
                xForm.apply(xv);
                newV.add(xv);
            }
            vertices = newV;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer tes = tessellator.func_178180_c();
        if (doBegin) {
            tes.func_181668_a(7, format);
        }
        for (Vertex v : vertices) {
            for (VertexFormatElement el : format.func_177343_g()) {
                switch (el.func_177375_c()) {
                    case COLOR: {
                        if (el.func_177367_b() != VertexFormatElement.EnumType.FLOAT) break;
                        tes.func_181666_a(v.r(), v.g(), v.b(), v.a());
                        break;
                    }
                    case NORMAL: {
                        tes.func_181663_c(v.nx(), v.ny(), v.nz());
                        break;
                    }
                    case POSITION: {
                        tes.func_181662_b(v.x(), v.y(), v.z());
                        break;
                    }
                    case UV: {
                        if (el.func_177367_b() != VertexFormatElement.EnumType.FLOAT || v.uv == null) break;
                        tes.func_187315_a((double)v.u(), (double)v.v());
                        break;
                    }
                    case GENERIC: {
                        break;
                    }
                    case PADDING: {
                        break;
                    }
                }
            }
            tes.func_181675_d();
        }
    }

    public static void getUvForCorner(Vector2f uv, Vector3d corner, int x, int y, int z, EnumFacing face, TextureAtlasSprite icon) {
        if (icon == null) {
            return;
        }
        Vector3d p = new Vector3d(corner);
        p.x -= (double)x;
        p.y -= (double)y;
        p.z -= (double)z;
        float uWidth = 1.0f;
        float vWidth = 1.0f;
        if (icon != null) {
            uWidth = icon.func_94212_f() - icon.func_94209_e();
            vWidth = icon.func_94210_h() - icon.func_94206_g();
        }
        uv.x = (float)VecmathUtil.distanceFromPointToPlane(RenderUtil.getUPlaneForFace(face), p);
        uv.y = (float)VecmathUtil.distanceFromPointToPlane(RenderUtil.getVPlaneForFace(face), p);
        if (icon != null) {
            uv.x = icon.func_94209_e() + uv.x * uWidth;
            uv.y = icon.func_94206_g() + uv.y * vWidth;
        }
    }

    public static Vector4d getVPlaneForFace(EnumFacing face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return new Vector4d(0.0, 0.0, 1.0, 0.0);
            }
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return new Vector4d(0.0, -1.0, 0.0, 1.0);
            }
        }
        return null;
    }

    public static Vector4d getUPlaneForFace(EnumFacing face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return new Vector4d(1.0, 0.0, 0.0, 0.0);
            }
            case EAST: {
                return new Vector4d(0.0, 0.0, -1.0, 1.0);
            }
            case WEST: {
                return new Vector4d(0.0, 0.0, 1.0, 0.0);
            }
            case NORTH: {
                return new Vector4d(-1.0, 0.0, 0.0, 1.0);
            }
            case SOUTH: {
                return new Vector4d(1.0, 0.0, 0.0, 0.0);
            }
        }
        return null;
    }

    public static EnumFacing getVDirForFace(EnumFacing face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return EnumFacing.SOUTH;
            }
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return EnumFacing.UP;
            }
        }
        return null;
    }

    public static EnumFacing getUDirForFace(EnumFacing face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.NORTH;
            }
            case WEST: {
                return EnumFacing.SOUTH;
            }
            case NORTH: {
                return EnumFacing.WEST;
            }
            case SOUTH: {
                return EnumFacing.EAST;
            }
        }
        return null;
    }

    public static TextureAtlasSprite getStillTexture(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            return null;
        }
        return RenderUtil.getStillTexture(fluid.getFluid());
    }

    public static TextureAtlasSprite getStillTexture(Fluid fluid) {
        ResourceLocation iconKey = fluid.getStill();
        if (iconKey == null) {
            return null;
        }
        return Minecraft.func_71410_x().func_147117_R().getTextureExtry(iconKey.toString());
    }

    public static void renderGuiTank(FluidTank tank, double x, double y, double zLevel, double width, double height) {
        RenderUtil.renderGuiTank(tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, zLevel, width, height);
    }

    public static void renderGuiTank(FluidStack fluid, int capacity, int amount, double x, double y, double zLevel, double width, double height) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = RenderUtil.getStillTexture(fluid);
        if (icon == null) {
            return;
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        RenderUtil.bindBlockTexture();
        int color = fluid.getFluid().getColor(fluid);
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
        GlStateManager.func_179147_l();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                VertexBuffer tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV).func_181675_d();
                tes.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GlStateManager.func_179084_k();
    }

    public static void drawBillboardedText(Vector3f pos, String text, float size) {
        RenderUtil.drawBillboardedText(pos, text, size, DEFAULT_TXT_COL, true, DEFAULT_TEXT_SHADOW_COL, true, DEFAULT_TEXT_BG_COL);
    }

    public static void drawBillboardedText(Vector3f pos, String text, float size, Vector4f bgCol) {
        RenderUtil.drawBillboardedText(pos, text, size, DEFAULT_TXT_COL, true, DEFAULT_TEXT_SHADOW_COL, true, bgCol);
    }

    public static void drawBillboardedText(Vector3f pos, String text, float size, Vector4f txtCol, boolean drawShadow, Vector4f shadowCol, boolean drawBackground, Vector4f bgCol) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)pos.x, (float)pos.y, (float)pos.z);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fnt = mc.field_71466_p;
        float scale = size / (float)fnt.field_78288_b;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)(mc.func_175598_ae().field_78735_i + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-mc.func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-fnt.func_78256_a(text) / 2), (float)0.0f, (float)0.0f);
        if (drawBackground) {
            RenderUtil.renderBackground(fnt, text, bgCol);
        }
        fnt.func_78276_b(text, 0, 0, ColorUtil.getRGBA(txtCol));
        if (drawShadow) {
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.1f);
            fnt.func_78276_b(text, 0, 0, ColorUtil.getRGBA(shadowCol));
        }
        GlStateManager.func_179121_F();
        RenderUtil.bindBlockTexture();
    }

    public static void renderBackground(FontRenderer fnt, String toRender, Vector4f color) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        RenderHelper.func_74518_a();
        float width = fnt.func_78256_a(toRender);
        float height = fnt.field_78288_b;
        float padding = 2.0f;
        GlStateManager.func_179131_c((float)color.x, (float)color.y, (float)color.z, (float)color.w);
        VertexBuffer tes = Tessellator.func_178181_a().func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tes.func_181662_b((double)(-padding), (double)(-padding), 0.0).func_181675_d();
        tes.func_181662_b((double)(-padding), (double)(height + padding), 0.0).func_181675_d();
        tes.func_181662_b((double)(width + padding), (double)(height + padding), 0.0).func_181675_d();
        tes.func_181662_b((double)(width + padding), (double)(-padding), 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
    }

    public static void render3DItem(EntityItem item, boolean rotate) {
        float rot = RenderUtil.getRotation(1.0f);
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)true);
        if (rotate &= Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        item.field_70290_d = 0.0f;
        Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)item, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
        GL11.glPopMatrix();
    }

    public static float getRotation(float mult) {
        return (float)ClientHandler.getTicksElapsed() * mult;
    }

    public static void renderBillboardQuad(float rot, double scale) {
        GL11.glPushMatrix();
        RenderUtil.rotateToPlayer();
        GL11.glPushMatrix();
        GL11.glRotatef((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer tes = tessellator.func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tes.func_181662_b(-scale, -scale, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_181662_b(-scale, scale, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tes.func_181662_b(scale, scale, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        tes.func_181662_b(scale, -scale, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void rotateToPlayer() {
        RenderManager rm = Minecraft.func_71410_x().func_175598_ae();
        GL11.glRotatef((float)(-rm.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rm.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static TextureAtlasSprite getTexture(IBlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static void renderBoundingBox(BoundingBox bb) {
        VertexBuffer tes = Tessellator.func_178181_a().func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            List<Vector3f> corners = bb.getCornersForFace(face);
            for (Vector3f v : corners) {
                tes.func_181662_b((double)v.x, (double)v.y, (double)v.z).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderBoundingBox(BoundingBox bb, IBlockState state) {
        RenderUtil.renderBoundingBox(bb, RenderUtil.getTexture(state));
    }

    public static void renderBoundingBox(BoundingBox bb, TextureAtlasSprite tex) {
        RenderUtil.renderBoundingBox(bb, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h());
    }

    public static void renderBoundingBox(BoundingBox bb, float minU, float maxU, float minV, float maxV) {
        VertexBuffer tes = Tessellator.func_178181_a().func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            List<Vertex> corners = bb.getCornersWithUvForFace(face, minU, maxU, minV, maxV);
            for (Vertex v : corners) {
                tes.func_181662_b(v.x(), v.y(), v.z()).func_187315_a((double)v.u(), (double)v.v()).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void registerReloadListener(IResourceManagerReloadListener obj) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(obj);
    }

    public static void setupLightmapCoords(BlockPos pos, World world) {
        float f = world.func_175699_k(pos);
        int l = RenderUtil.getLightBrightnessForSkyBlocks(world, pos, 0);
        int l1 = l % 65536;
        int l2 = l / 65536;
        GlStateManager.func_179124_c((float)f, (float)f, (float)f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
    }

    public static int getLightBrightnessForSkyBlocks(World world, BlockPos pos, int min) {
        int i1 = world.func_175642_b(EnumSkyBlock.SKY, pos);
        int j1 = world.func_175642_b(EnumSkyBlock.BLOCK, pos);
        if (j1 < min) {
            j1 = min;
        }
        return i1 << 20 | j1 << 4;
    }

    public static void renderBlockModel(World world, BlockPos pos, boolean translateToOrigin) {
        VertexBuffer wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        if (translateToOrigin) {
            wr.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        }
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            IBlockState state = world.func_180495_p(pos);
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
            blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)world, ibakedmodel, state, pos, Tessellator.func_178181_a().func_178180_c(), false);
        }
        if (translateToOrigin) {
            wr.func_178969_c(0.0, 0.0, 0.0);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderBlockModelAsItem(World world, ItemStack stack, IBlockState state) {
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = blockrendererdispatcher.func_175023_a().func_178125_b(state);
        if (model != null) {
            Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
        }
    }

    public static void addBakedQuads(List<BakedQuad> quads, BoundingBox bb, TextureAtlasSprite tex) {
        RenderUtil.addBakedQuads(quads, bb, tex, null);
    }

    public static void addBakedQuads(List<BakedQuad> quads, BoundingBox bb, TextureAtlasSprite tex, Vector4f color) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            RenderUtil.addBakedQuadForFace(quads, bb, tex, face, false, false, color);
        }
    }

    public static void addBakedQuadForFace(List<BakedQuad> quads, BoundingBox bb, TextureAtlasSprite tex, EnumFacing face) {
        RenderUtil.addBakedQuadForFace(quads, bb, tex, face, false, false);
    }

    public static void addBakedQuadForFace(List<BakedQuad> quads, BoundingBox bb, TextureAtlasSprite tex, EnumFacing face, boolean rotateUV, boolean flipU) {
        RenderUtil.addBakedQuadForFace(quads, bb, tex, face, rotateUV, flipU, null);
    }

    public static void addBakedQuadForFace(List<BakedQuad> quads, BoundingBox bb, TextureAtlasSprite tex, EnumFacing face, VertexTransform xform) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        List<Vertex> corners = bb.getCornersWithUvForFace(face);
        builder.setQuadOrientation(face);
        for (Vertex v : corners) {
            if (xform != null) {
                xform.apply(v);
            }
            RenderUtil.putVertexData(builder, v, face.func_176730_m(), tex);
        }
        quads.add((BakedQuad)builder.build());
    }

    public static void addBakedQuadForFace(List<BakedQuad> quads, BoundingBox bb, TextureAtlasSprite tex, EnumFacing face, boolean rotateUV, boolean flipU, Vector4f color) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        List<Vertex> corners = bb.getCornersWithUvForFace(face);
        builder.setQuadOrientation(face);
        for (Vertex v : corners) {
            v.color = color;
            if (rotateUV) {
                float u = v.uv.x;
                v.uv.x = v.uv.y;
                v.uv.y = u;
            }
            if (flipU) {
                v.uv.x = 1.0f - v.uv.x;
            }
            RenderUtil.putVertexData(builder, v, face.func_176730_m(), tex);
        }
        quads.add((BakedQuad)builder.build());
    }

    public static void addBakedQuads(List<BakedQuad> quads, Collection<Vertex> vertices, TextureAtlasSprite tex, Vector4f color) {
        UnpackedBakedQuad.Builder builder = null;
        Iterator<Vertex> it = vertices.iterator();
        while (it.hasNext()) {
            EnumFacing face = null;
            for (int i = 0; i < 4; ++i) {
                Vertex v = it.next();
                if (i == 0) {
                    face = EnumFacing.func_176737_a((float)v.nx(), (float)v.ny(), (float)v.nz());
                    builder = new UnpackedBakedQuad.Builder(Attributes.DEFAULT_BAKED_FORMAT);
                    builder.setQuadOrientation(face);
                }
                v.color = color;
                RenderUtil.putVertexData(builder, v, face.func_176730_m(), tex);
            }
            quads.add((BakedQuad)builder.build());
        }
    }

    private static void putVertexData(UnpackedBakedQuad.Builder builder, Vertex v, Vec3i normal, TextureAtlasSprite sprite) {
        if (sprite == null) {
            sprite = IconUtil.instance.errorTexture;
        }
        VertexFormat format = builder.getVertexFormat();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)v.x(), (float)v.y(), (float)v.z(), 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float d = v.normal != null ? LightUtil.diffuseLight((float)v.normal.x, (float)v.normal.y, (float)v.normal.z) : LightUtil.diffuseLight((float)normal.func_177958_n(), (float)normal.func_177956_o(), (float)normal.func_177952_p());
                    if (v.color != null) {
                        builder.put(e, new float[]{d * v.color.x, d * v.color.y, d * v.color.z, v.color.w});
                        continue block6;
                    }
                    builder.put(e, new float[]{d, d, d, 1.0f});
                    continue block6;
                }
                case UV: {
                    builder.put(e, new float[]{sprite.func_94214_a((double)(v.u() * 16.0f)), sprite.func_94207_b((double)(v.v() * 16.0f)), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    if (v.normal != null) {
                        builder.put(e, new float[]{v.nx(), v.ny(), v.nz(), 0.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{normal.func_177958_n(), normal.func_177956_o(), normal.func_177952_p(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }
}

