/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.util.FluidUtil;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public abstract class BlockEnder<T extends TileEntityBase>
extends Block {
    @Nullable
    protected final Class<? extends T> teClass;
    @Nonnull
    protected final String name;

    protected BlockEnder(@Nonnull String name, @Nullable Class<? extends T> teClass) {
        this(name, teClass, new Material(MapColor.field_151668_h));
    }

    protected BlockEnder(@Nonnull String name, @Nullable Class<? extends T> teClass, @Nonnull Material mat) {
        super(mat);
        this.teClass = teClass;
        this.name = name;
        this.func_149711_c(0.5f);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity(this.teClass, (String)(this.name + "TileEntity"));
        }
        GameRegistry.register((IForgeRegistryEntry)this.createItemBlock());
    }

    protected ItemBlock createItemBlock() {
        ItemBlock ib = new ItemBlock((Block)this);
        ib.setRegistryName(this.getName());
        return ib;
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.teClass != null;
    }

    @Nonnull
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (this.teClass != null) {
            try {
                TileEntityBase te = (TileEntityBase)((Object)this.teClass.newInstance());
                te.init();
                return te;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create tile entity for block " + this.name + " for class " + this.teClass, e);
            }
        }
        throw new RuntimeException("Cannot create a TileEntity for a block that doesn't have a TileEntity. This is not a problem with EnderCore, this is caused by the caller.");
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ITankAccess) {
            if (FluidUtil.fillInternalTankFromPlayerHandItem(worldIn, pos, playerIn, hand, (ITankAccess)te)) {
                return true;
            }
            if (FluidUtil.fillPlayerHandItemFromInternalTank(worldIn, pos, playerIn, hand, (ITankAccess)te)) {
                return true;
            }
        }
        return this.openGui(worldIn, pos, playerIn, side);
    }

    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public boolean doNormalDrops(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (world == null || pos == null || this.doNormalDrops(world, pos)) {
            return super.getDrops(world, pos, state, fortune);
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getNBTDrop(world, pos, this.getTileEntity(world, pos))});
    }

    public ItemStack getNBTDrop(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable T te) {
        int meta = this.func_180651_a(world.func_180495_p(pos));
        ItemStack itemStack = new ItemStack((Block)this, 1, meta);
        this.processDrop(world, pos, te, itemStack);
        return itemStack;
    }

    protected void processDrop(IBlockAccess world, BlockPos pos, @Nullable T te, ItemStack drop) {
    }

    @Nullable
    protected T getTileEntity(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (this.teClass != null) {
            TileEntity te = world.func_175625_s(pos);
            Class<T> teClass2 = this.teClass;
            if (teClass2 != null && teClass2.isInstance(te)) {
                return (T)((Object)((TileEntityBase)te));
            }
        }
        return null;
    }

    protected boolean shouldDoWorkThisTick(@Nonnull World world, @Nonnull BlockPos pos, int interval) {
        T te = this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return world.func_82737_E() % (long)interval == 0L;
        }
        return ((TileEntityBase)((Object)te)).shouldDoWorkThisTick(interval);
    }

    protected boolean shouldDoWorkThisTick(@Nonnull World world, @Nonnull BlockPos pos, int interval, int offset) {
        T te = this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return (world.func_82737_E() + (long)offset) % (long)interval == 0L;
        }
        return ((TileEntityBase)((Object)te)).shouldDoWorkThisTick(interval, offset);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }
}

