/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.fluid;

import com.enderio.core.common.fluid.IFluidWrapper;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidContainerItemFluidWrapper
implements IFluidWrapper {
    private final IFluidContainerItem fluidContainerItem;
    private final ItemStack itemStack;

    public FluidContainerItemFluidWrapper(IFluidContainerItem fluidContainerItem, ItemStack itemStack) {
        this.fluidContainerItem = fluidContainerItem;
        this.itemStack = itemStack;
    }

    @Override
    public int offer(FluidStack resource) {
        return this.fluidContainerItem.fill(this.itemStack, resource, false);
    }

    @Override
    public int fill(FluidStack resource) {
        return this.fluidContainerItem.fill(this.itemStack, resource, true);
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource) {
        if (resource.isFluidEqual(this.getAvailableFluid())) {
            return this.fluidContainerItem.drain(this.itemStack, resource.amount, true);
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack getAvailableFluid() {
        return this.fluidContainerItem.getFluid(this.itemStack);
    }

    @Override
    @Nonnull
    public List<IFluidWrapper.ITankInfoWrapper> getTankInfoWrappers() {
        return Collections.singletonList(new InfoWrapper());
    }

    private class InfoWrapper
    implements IFluidWrapper.ITankInfoWrapper {
        private InfoWrapper() {
        }

        @Override
        public IFluidTankProperties getIFluidTankProperties() {
            return new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return FluidContainerItemFluidWrapper.this.fluidContainerItem.getFluid(FluidContainerItemFluidWrapper.this.itemStack);
                }

                public int getCapacity() {
                    return FluidContainerItemFluidWrapper.this.fluidContainerItem.getCapacity(FluidContainerItemFluidWrapper.this.itemStack);
                }

                public boolean canFill() {
                    return true;
                }

                public boolean canDrain() {
                    return true;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return true;
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return true;
                }
            };
        }

        @Override
        public FluidTankInfo getFluidTankInfo() {
            return new FluidTankInfo(FluidContainerItemFluidWrapper.this.fluidContainerItem.getFluid(FluidContainerItemFluidWrapper.this.itemStack), FluidContainerItemFluidWrapper.this.fluidContainerItem.getCapacity(FluidContainerItemFluidWrapper.this.itemStack));
        }
    }
}

