/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.fluid;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.CapabilityFluidWrapper;
import com.enderio.core.common.fluid.FluidContainerItemFluidWrapper;
import com.enderio.core.common.fluid.FluidTankFluidWrapper;
import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.fluid.LegacyFluidWrapper;
import com.enderio.core.common.fluid.TankAccessFluidWrapper;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidWrapper {
    @CapabilityInject(value=IFluidHandler.class)
    private static final Capability<IFluidHandler> FLUID_HANDLER = null;

    @Nullable
    public static IFluidWrapper wrap(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (world == null || pos == null) {
            return null;
        }
        return FluidWrapper.wrap(world.func_175625_s(pos), side);
    }

    @Nullable
    public static IFluidWrapper wrap(@Nullable TileEntity te, EnumFacing side) {
        if (te != null && te.func_145830_o() && !te.func_145837_r()) {
            if (te instanceof IFluidWrapper) {
                return (IFluidWrapper)te;
            }
            if (te.hasCapability(FLUID_HANDLER, side)) {
                return FluidWrapper.wrap((IFluidHandler)te.getCapability(FLUID_HANDLER, side));
            }
            if (te instanceof net.minecraftforge.fluids.IFluidHandler) {
                return FluidWrapper.wrap((net.minecraftforge.fluids.IFluidHandler)te, side);
            }
        }
        return null;
    }

    public static TankAccessFluidWrapper wrap(ITankAccess tankAccess) {
        return new TankAccessFluidWrapper(tankAccess);
    }

    public static LegacyFluidWrapper wrap(net.minecraftforge.fluids.IFluidHandler fluidHandler, EnumFacing side) {
        if (fluidHandler != null) {
            return new LegacyFluidWrapper(fluidHandler, side);
        }
        return null;
    }

    public static CapabilityFluidWrapper wrap(IFluidHandler fluidHandler) {
        if (fluidHandler != null) {
            return new CapabilityFluidWrapper(fluidHandler);
        }
        return null;
    }

    @Nullable
    public static IFluidWrapper wrap(@Nullable FluidTank tank) {
        if (tank != null) {
            return new FluidTankFluidWrapper(tank);
        }
        return null;
    }

    @Nullable
    public static IFluidWrapper wrap(@Nullable IFluidWrapper wrapper) {
        return wrapper;
    }

    @Nullable
    public static IFluidWrapper wrap(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof IFluidContainerItem) {
            return new FluidContainerItemFluidWrapper((IFluidContainerItem)itemStack.func_77973_b(), itemStack);
        }
        return FluidWrapper.wrap(FluidUtil.getFluidHandler((ItemStack)itemStack));
    }

    public static Map<EnumFacing, IFluidWrapper> wrapNeighbours(IBlockAccess world, BlockPos pos) {
        EnumMap<EnumFacing, IFluidWrapper> res = new EnumMap<EnumFacing, IFluidWrapper>(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.values()) {
            IFluidWrapper wrapper = FluidWrapper.wrap(world, pos.func_177972_a(dir), dir.func_176734_d());
            if (wrapper == null) continue;
            res.put(dir, wrapper);
        }
        return res;
    }

    public static int transfer(FluidTank from, FluidTank to, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from), FluidWrapper.wrap(to), limit);
    }

    public static int transfer(FluidTank from, IFluidWrapper to, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from), FluidWrapper.wrap(to), limit);
    }

    public static int transfer(FluidTank from, IBlockAccess world, BlockPos topos, EnumFacing toside, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from), FluidWrapper.wrap(world, topos, toside), limit);
    }

    public static int transfer(FluidTank from, TileEntity to, EnumFacing toside, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from), FluidWrapper.wrap(to, toside), limit);
    }

    public static int transfer(IFluidWrapper from, FluidTank to, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from), FluidWrapper.wrap(to), limit);
    }

    public static int transfer(IFluidWrapper from, IBlockAccess world, BlockPos topos, EnumFacing toside, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from), FluidWrapper.wrap(world, topos, toside), limit);
    }

    public static int transfer(IFluidWrapper from, TileEntity to, EnumFacing toside, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from), FluidWrapper.wrap(to, toside), limit);
    }

    public static int transfer(IBlockAccess world, BlockPos frompos, EnumFacing fromside, IFluidWrapper to, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(world, frompos, fromside), FluidWrapper.wrap(to), limit);
    }

    public static int transfer(IBlockAccess world, BlockPos frompos, EnumFacing fromside, FluidTank to, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(world, frompos, fromside), FluidWrapper.wrap(to), limit);
    }

    public static int transfer(IBlockAccess world, BlockPos frompos, EnumFacing fromside, BlockPos topos, EnumFacing toside, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(world, frompos, fromside), FluidWrapper.wrap(world, topos, toside), limit);
    }

    public static int transfer(IBlockAccess world, BlockPos frompos, EnumFacing fromside, TileEntity to, EnumFacing toside, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(world, frompos, fromside), FluidWrapper.wrap(to, toside), limit);
    }

    public static int transfer(TileEntity from, EnumFacing fromside, IFluidWrapper to, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from, fromside), FluidWrapper.wrap(to), limit);
    }

    public static int transfer(TileEntity from, EnumFacing fromside, FluidTank to, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from, fromside), FluidWrapper.wrap(to), limit);
    }

    public static int transfer(TileEntity from, EnumFacing fromside, IBlockAccess world, BlockPos topos, EnumFacing toside, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from, fromside), FluidWrapper.wrap(world, topos, toside), limit);
    }

    public static int transfer(TileEntity from, EnumFacing fromside, TileEntity to, EnumFacing toside, int limit) {
        return FluidWrapper.transfer(FluidWrapper.wrap(from, fromside), FluidWrapper.wrap(to, toside), limit);
    }

    public static int transfer(IFluidWrapper from, IFluidWrapper to, int limit) {
        int fillable;
        if (from == null || to == null || limit <= 0) {
            return 0;
        }
        FluidStack drainable = from.getAvailableFluid();
        if (drainable == null || drainable.amount <= 0) {
            return 0;
        }
        if (drainable.amount > limit) {
            drainable = drainable.copy();
            drainable.amount = limit;
        }
        if ((fillable = to.offer(drainable)) <= 0 || fillable > drainable.amount) {
            return 0;
        }
        if (fillable < drainable.amount) {
            drainable.amount = fillable;
        }
        return to.fill(from.drain(drainable));
    }
}

