/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.transform;

import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.transform.EnderCorePlugin;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@IFMLLoadingPlugin.MCVersion(value="1.10")
public class EnderCoreTransformer
implements IClassTransformer {
    public static final Logger logger = LogManager.getLogger((String)"EnderCore");
    private static final String anvilContainerClass = "net.minecraft.inventory.ContainerRepair";
    private static final ObfSafeName anvilContainerMethod;
    private static final String anvilGuiClass = "net.minecraft.client.gui.GuiRepair";
    private static final ObfSafeName anvilGuiMethod;
    private static final String containerFurnaceClass = "net.minecraft.inventory.ContainerFurnace";
    private static final ObfSafeName containerFurnaceMethod;
    private static final String containerFurnaceMethodSig = "(Lnet/minecraft/inventory/ContainerFurnace;Lnet/minecraft/entity/player/EntityPlayer;I)Lnet/minecraft/item/ItemStack;";
    private static final String renderItemClass = "net.minecraft.client.renderer.RenderItem";
    private static final ObfSafeName renderItemOverlayIntoGUIMethod;
    private static final Set<String> transformableClasses;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean doGameplayChanges = true;
        if (transformableClasses.contains(transformedName) && ConfigHandler.invisibleMode == 1) {
            doGameplayChanges = false;
        }
        if (doGameplayChanges && (transformedName.equals(anvilContainerClass) || transformedName.equals(anvilGuiClass))) {
            basicClass = this.transform(basicClass, transformedName, transformedName.equals(anvilContainerClass) ? anvilContainerMethod : anvilGuiMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    int done = 0;
                    while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!anvilContainerMethod.equals(m.name) && !anvilGuiMethod.equals(m.name)) continue;
                        for (int i = 0; i < m.instructions.size(); ++i) {
                            AbstractInsnNode next = m.instructions.get(i);
                            next = m.instructions.get(i);
                            if (!(next instanceof IntInsnNode) || ((IntInsnNode)next).operand != 40) continue;
                            m.instructions.set(next, (AbstractInsnNode)new MethodInsnNode(184, "com/enderio/core/common/transform/EnderCoreMethods", "getMaxAnvilCost", "()I", false));
                            ++done;
                        }
                    }
                    if (done > 2 || done < 1) {
                        logger.info("Transforming failed. (" + done + ")");
                    }
                }
            });
        }
        if (doGameplayChanges && transformedName.equals(containerFurnaceClass)) {
            basicClass = this.transform(basicClass, containerFurnaceClass, containerFurnaceMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    boolean done = false;
                    while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!containerFurnaceMethod.equals(m.name)) continue;
                        m.instructions.clear();
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
                        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/enderio/core/common/transform/EnderCoreMethods", "transferStackInSlot", EnderCoreTransformer.containerFurnaceMethodSig, false));
                        m.instructions.add((AbstractInsnNode)new InsnNode(176));
                        done = true;
                        break;
                    }
                    if (!done) {
                        logger.info("Transforming failed.");
                    }
                }
            });
        }
        if (transformedName.equals(renderItemClass)) {
            basicClass = this.transform(basicClass, renderItemClass, renderItemOverlayIntoGUIMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    boolean done = false;
                    block0: while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!renderItemOverlayIntoGUIMethod.equals(m.name)) continue;
                        boolean primed = false;
                        Label target = null;
                        for (int i = 0; i < m.instructions.size(); ++i) {
                            AbstractInsnNode next = m.instructions.get(i);
                            if (!primed && target == null && next.getOpcode() == 182 && next instanceof MethodInsnNode && "showDurabilityBar".equals(((MethodInsnNode)next).name)) {
                                primed = true;
                            }
                            if (primed && next.getOpcode() == 153 && next instanceof JumpInsnNode) {
                                target = ((JumpInsnNode)next).label.getLabel();
                                primed = false;
                            }
                            if (target == null || !(next instanceof LabelNode) || ((LabelNode)next).getLabel() != target) continue;
                            InsnList toAdd = new InsnList();
                            toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                            toAdd.add((AbstractInsnNode)new VarInsnNode(21, 3));
                            toAdd.add((AbstractInsnNode)new VarInsnNode(21, 4));
                            toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "com/enderio/core/common/transform/EnderCoreMethods", "renderItemOverlayIntoGUI", "(Lnet/minecraft/item/ItemStack;II)V", false));
                            m.instructions.insert(next, toAdd);
                            done = true;
                            break block0;
                        }
                    }
                    if (!done) {
                        logger.info("Transforming failed.");
                    }
                }
            });
        }
        return basicClass;
    }

    protected final byte[] transform(byte[] classBytes, String className, ObfSafeName methodName, Transform transformer) {
        logger.info("Transforming Class [" + className + "], Method [" + methodName.getName() + "]");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Iterator<MethodNode> methods = classNode.methods.iterator();
        transformer.transform(methods);
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        logger.info("Transforming " + className + " Finished.");
        return cw.toByteArray();
    }

    static {
        Launch.classLoader.addTransformerExclusion("com.enderio.core.common.config.");
        Launch.classLoader.addTransformerExclusion("com.enderio.core.api.common.config.");
        Launch.classLoader.addTransformerExclusion("com.enderio.core.common.Lang");
        anvilContainerMethod = new ObfSafeName("updateRepairOutput", "func_82848_d");
        anvilGuiMethod = new ObfSafeName("drawGuiContainerForegroundLayer", "func_146979_b");
        containerFurnaceMethod = new ObfSafeName("transferStackInSlot", "func_82846_b");
        renderItemOverlayIntoGUIMethod = new ObfSafeName("renderItemOverlayIntoGUI", "func_180453_a");
        transformableClasses = Sets.newHashSet((Object[])new String[]{containerFurnaceClass, renderItemClass});
    }

    protected static abstract class Transform {
        protected Transform() {
        }

        abstract void transform(Iterator<MethodNode> var1);
    }

    protected static class ObfSafeName {
        private String deobf;
        private String srg;

        public ObfSafeName(String deobf, String srg) {
            this.deobf = deobf;
            this.srg = srg;
        }

        public String getName() {
            return EnderCorePlugin.runtimeDeobfEnabled ? this.srg : this.deobf;
        }

        public boolean equals(Object obj) {
            if (obj instanceof String) {
                return obj.equals(this.deobf) || obj.equals(this.srg);
            }
            if (obj instanceof ObfSafeName) {
                return ((ObfSafeName)obj).deobf.equals(this.deobf) && ((ObfSafeName)obj).srg.equals(this.srg);
            }
            return false;
        }
    }
}

