/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.EnderCore;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.asm.ModAnnotation;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;

public class Handlers {
    private static final Set<String> packageSet = new HashSet<String>();
    private static Set<ASMDataTable.ASMData> annotations;
    private static boolean registered;
    private static final Field _value;

    public static void preInit(FMLPreInitializationEvent event) {
        annotations = event.getAsmData().getAll(Handler.class.getName());
    }

    @Deprecated
    public static void addPackage(String packageName) {
        if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new RuntimeException("This method must only be called in preinit");
        }
        EnderCore.logger.info("Adding package " + packageName + " to handler search.");
        packageSet.add(packageName);
    }

    public static void register(FMLInitializationEvent event) {
        if (registered) {
            throw new IllegalStateException("I warned you!");
        }
        for (ASMDataTable.ASMData data : annotations) {
            String className = data.getClassName();
            if (Handlers.shouldLoad(data)) {
                try {
                    Class<?> c = Class.forName(className);
                    Handler a = c.getAnnotation(Handler.class);
                    if (a == null) continue;
                    Handlers.registerHandler(c, data, a);
                }
                catch (Throwable t) {
                    EnderCore.logger.error(String.format("[Handlers] %s threw an error on load, skipping...", className));
                    t.printStackTrace();
                }
                continue;
            }
            EnderCore.logger.info(String.format("[Handlers] Skipping class %s, it is not loaded on this side.", className));
        }
        registered = true;
    }

    private static boolean shouldLoad(ASMDataTable.ASMData data) {
        ModAnnotation.EnumHolder holder = (ModAnnotation.EnumHolder)data.getAnnotationInfo().get("side");
        try {
            Handler.HandlerSide side = holder == null ? Handler.HandlerSide.AUTO : Handler.HandlerSide.valueOf((String)_value.get(holder));
            Side currentSide = FMLCommonHandler.instance().getEffectiveSide();
            if (side == null || side == Handler.HandlerSide.AUTO) {
                return !data.getClassName().contains("client") || currentSide.isClient();
            }
            return side.equals(currentSide);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
            return false;
        }
    }

    private static void registerHandler(Class<?> c, ASMDataTable.ASMData data, Handler handler) throws InstantiationException, IllegalAccessException {
        EnderCore.logger.info(String.format("[Handlers] Registering handler %s to busses: %s", c.getSimpleName(), Arrays.deepToString((Object[])handler.value())));
        Object inst = Handlers.tryInit(handler, c);
        Method[] methods = c.getDeclaredMethods();
        EnumSet<HandlerType> types = EnumSet.noneOf(HandlerType.class);
        block0: for (Method m : methods) {
            Class<?>[] params;
            if (!m.isAnnotationPresent(SubscribeEvent.class) || (params = m.getParameterTypes()).length < 1) continue;
            for (Class<?> param = params[0]; param != Event.class && param != null && param != Object.class; param = param.getSuperclass()) {
                for (HandlerType type : HandlerType.values()) {
                    if (!param.getName().contains(type.eventIdentifier)) continue;
                    types.add(type);
                    continue block0;
                }
            }
        }
        for (HandlerType type : types) {
            type.bus.register(inst);
        }
    }

    private static Object tryInit(Handler annot, Class<?> c) {
        AccessibleObject inst3;
        Handler.Inst pref = annot.getInstFrom();
        if (pref.matches(Handler.Inst.CONSTRUCTOR)) {
            try {
                return c.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pref.matches(Handler.Inst.FIELD)) {
            try {
                Field inst2 = c.getDeclaredField("INSTANCE");
                inst2.setAccessible(true);
                return inst2.get(null);
            }
            catch (Exception inst2) {
                // empty catch block
            }
        }
        if (pref.matches(Handler.Inst.METHOD)) {
            try {
                inst3 = c.getDeclaredMethod("instance", new Class[0]);
                ((Method)inst3).setAccessible(true);
                return ((Method)inst3).invoke(null, new Object[0]);
            }
            catch (Exception inst3) {
                // empty catch block
            }
        }
        if (pref.matches(Handler.Inst.SCALA_OBJECT)) {
            try {
                inst3 = Class.forName(c.getName() + "$").getDeclaredField("MODULE$");
                ((Field)inst3).setAccessible(true);
                return ((Field)inst3).get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Could not instantiate @Handler class " + c.getName() + " or access INSTANCE field or instance() method.");
    }

    static {
        registered = false;
        _value = ReflectionHelper.findField(ModAnnotation.EnumHolder.class, (String[])new String[]{"value"});
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Handler {
        @Deprecated
        public HandlerType[] value() default {HandlerType.FORGE, HandlerType.FML};

        public Inst getInstFrom() default Inst.AUTO;

        public HandlerSide side() default HandlerSide.AUTO;

        public static enum HandlerSide {
            AUTO,
            COMMON,
            CLIENT,
            SERVER;


            public boolean equals(Side other) {
                if (this == COMMON) {
                    return true;
                }
                return this == CLIENT ? other == Side.CLIENT : other == Side.SERVER;
            }
        }

        public static enum Inst {
            AUTO,
            CONSTRUCTOR,
            FIELD,
            METHOD,
            SCALA_OBJECT;


            boolean matches(Inst other) {
                return this == AUTO || other == AUTO || other == this;
            }
        }

        @Deprecated
        public static enum HandlerType {
            FORGE,
            FML;

        }
    }

    public static enum HandlerType {
        FORGE_OREGEN("net.minecraftforge.event.terraingen.OreGenEvent", MinecraftForge.ORE_GEN_BUS),
        FORGE_TERRAIN("net.minecraftforge.event.terraingen", MinecraftForge.TERRAIN_GEN_BUS),
        FORGE("net.minecraftforge", MinecraftForge.EVENT_BUS),
        FML("cpw.mods.fml", FMLCommonHandler.instance().bus());

        public final String eventIdentifier;
        public final EventBus bus;

        private HandlerType(String eventIdentifier, EventBus bus) {
            this.eventIdentifier = eventIdentifier;
            this.bus = bus;
        }
    }
}

