/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.ConnectionHandler;
import crazypants.enderio.machine.transceiver.PacketAddRemoveChannel;
import crazypants.enderio.machine.transceiver.PacketChannelList;
import crazypants.enderio.machine.transceiver.PacketItemFilter;
import crazypants.enderio.machine.transceiver.PacketSendRecieveChannel;
import crazypants.enderio.machine.transceiver.PacketSendRecieveChannelList;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.machine.transceiver.gui.ContainerTransceiver;
import crazypants.enderio.machine.transceiver.gui.GuiTransceiver;
import crazypants.enderio.network.PacketHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockTransceiver
extends AbstractMachineBlock<TileTransceiver> {
    public static BlockTransceiver create() {
        PacketHandler.INSTANCE.registerMessage(PacketSendRecieveChannel.class, PacketSendRecieveChannel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketAddRemoveChannel.class, PacketAddRemoveChannel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketAddRemoveChannel.class, PacketAddRemoveChannel.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketChannelList.class, PacketChannelList.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketSendRecieveChannelList.class, PacketSendRecieveChannelList.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketItemFilter.class, PacketItemFilter.class, PacketHandler.nextID(), Side.SERVER);
        ConnectionHandler ch = new ConnectionHandler();
        FMLCommonHandler.instance().bus().register((Object)ch);
        MinecraftForge.EVENT_BUS.register((Object)ch);
        BlockTransceiver res = new BlockTransceiver();
        res.init();
        return res;
    }

    private BlockTransceiver() {
        super(ModObject.blockTransceiver, TileTransceiver.class);
        if (!Config.transceiverEnabled) {
            this.func_149647_a(null);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean doHarvest) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileTransceiver) {
            ((TileTransceiver)te).getRailController().dropNonSpawnedCarts();
        }
        return super.removedByPlayer(world, player, x, y, z, doHarvest);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTransceiver) {
            return new ContainerTransceiver(player.field_71071_by, (TileTransceiver)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return new GuiTransceiver(player.field_71071_by, (TileTransceiver)te);
    }

    @Override
    protected int getGuiId() {
        return 97;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerOverlayIcons(IIconRegister iIconRegister) {
        super.registerOverlayIcons(iIconRegister);
        this.overlayIconPull = iIconRegister.func_94245_a("enderio:overlays/transcieverPull");
        this.overlayIconPush = iIconRegister.func_94245_a("enderio:overlays/transcieverPush");
        this.overlayIconPushPull = iIconRegister.func_94245_a("enderio:overlays/transcieverPushPull");
        this.overlayIconDisabled = iIconRegister.func_94245_a("enderio:overlays/transcieverDisabled");
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:alloySmelterFrontOn";
        }
        return "enderio:alloySmelterFront";
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTransceiver && player.func_70093_af()) {
            TileTransceiver trans = (TileTransceiver)te;
            for (ChannelType type : ChannelType.VALUES) {
                Set<Channel> recieving = trans.getRecieveChannels(type);
                Set<Channel> sending = trans.getSendChannels(type);
                String recieve = "[" + this.buildString(recieving) + "]";
                String send = "[" + this.buildString(sending) + "]";
                if (this.isEmpty(recieve) && this.isEmpty(send)) continue;
                tooltip.add(EnumChatFormatting.WHITE + EnderIO.lang.localize("trans." + type.name().toLowerCase(Locale.US)));
                if (!this.isEmpty(recieve)) {
                    tooltip.add(String.format("%s%s " + Util.TAB + ": %s%s", Util.TAB, EnderIO.lang.localize("trans.receiving"), Util.TAB + Util.ALIGNRIGHT + EnumChatFormatting.WHITE, recieve));
                }
                if (this.isEmpty(send)) continue;
                tooltip.add(String.format("%s%s " + Util.TAB + ": %s%s", Util.TAB, EnderIO.lang.localize("trans.sending"), Util.TAB + Util.ALIGNRIGHT + EnumChatFormatting.WHITE, send));
            }
        }
    }

    private boolean isEmpty(String str) {
        return "[]".equals(str);
    }

    private String buildString(Set<Channel> recieving) {
        StringBuilder sb = new StringBuilder();
        Iterator<Channel> iter = recieving.iterator();
        while (iter.hasNext()) {
            Channel c = iter.next();
            sb.append(c.getName());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

