/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.vat.ContainerVat;
import crazypants.enderio.machine.vat.GuiVat;
import crazypants.enderio.machine.vat.PacketDumpTank;
import crazypants.enderio.machine.vat.PacketTanks;
import crazypants.enderio.machine.vat.PacketVatProgress;
import crazypants.enderio.machine.vat.TileVat;
import crazypants.enderio.network.PacketHandler;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockVat
extends AbstractMachineBlock<TileVat> {
    public static int renderId;
    protected IIcon onIcon;
    protected IIcon topIcon;
    protected IIcon blockIconSingle;
    protected IIcon blockIconSingleOn;
    protected IIcon[][] overlays;

    public static BlockVat create() {
        PacketHandler.INSTANCE.registerMessage(PacketTanks.class, PacketTanks.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketVatProgress.class, PacketVatProgress.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketDumpTank.class, PacketDumpTank.class, PacketHandler.nextID(), Side.SERVER);
        BlockVat res = new BlockVat();
        res.init();
        return res;
    }

    public BlockVat() {
        super(ModObject.blockVat, TileVat.class);
    }

    @Override
    protected String getModelIconKey(boolean active) {
        return "enderio:vatModel";
    }

    public int func_149717_k() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerOverlayIcons(IIconRegister iIconRegister) {
        super.registerOverlayIcons(iIconRegister);
        this.overlays = new IIcon[2][IoMode.values().length];
        this.overlays[0][IoMode.PULL.ordinal()] = iIconRegister.func_94245_a("enderio:overlays/pullSides");
        this.overlays[0][IoMode.PUSH.ordinal()] = iIconRegister.func_94245_a("enderio:overlays/pushSides");
        this.overlays[0][IoMode.PUSH_PULL.ordinal()] = iIconRegister.func_94245_a("enderio:overlays/pushPullSides");
        this.overlays[0][IoMode.DISABLED.ordinal()] = iIconRegister.func_94245_a("enderio:overlays/disabledNoCenter");
        this.overlays[1][IoMode.PULL.ordinal()] = iIconRegister.func_94245_a("enderio:overlays/pullTopBottom");
        this.overlays[1][IoMode.PUSH.ordinal()] = iIconRegister.func_94245_a("enderio:overlays/pushTopBottom");
        this.overlays[1][IoMode.PUSH_PULL.ordinal()] = iIconRegister.func_94245_a("enderio:overlays/pushPullTopBottom");
        this.overlays[1][IoMode.DISABLED.ordinal()] = this.overlays[0][IoMode.DISABLED.ordinal()];
    }

    @Override
    public IIcon getOverlayIconForMode(TileVat tile, ForgeDirection face, IoMode mode) {
        ForgeDirection side = tile.getFacingDir().getRotation(ForgeDirection.DOWN);
        if (mode == IoMode.DISABLED || face == side || face == side.getOpposite()) {
            return super.getOverlayIconForMode(tile, face, mode);
        }
        if (face == ForgeDirection.UP) {
            return this.overlays[1][mode.ordinal()];
        }
        return this.overlays[0][mode.ordinal()];
    }

    @Override
    public int func_149645_b() {
        return renderId;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileVat) {
            return new ContainerVat(player.field_71071_by, (TileVat)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileVat) {
            return new GuiVat(player.field_71071_by, (TileVat)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess p_149646_1_, int p_149646_2_, int p_149646_3_, int p_149646_4_, int p_149646_5_) {
        return true;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        return this.getBackIconKey(active);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.isActive((IBlockAccess)world, x, y, z)) {
            TileVat te = (TileVat)world.func_147438_o(x, y, z);
            float pX = (float)x + 0.5f;
            float pY = (float)y + 0.7f;
            float pZ = (float)z + 0.5f;
            ForgeDirection dir = te.getFacingDir();
            pX += 0.6f * (float)dir.offsetX;
            pZ += 0.6f * (float)dir.offsetZ;
            double velX = (rand.nextDouble() * 0.075 + 0.025) * (double)dir.offsetX;
            double velZ = (rand.nextDouble() * 0.075 + 0.025) * (double)dir.offsetZ;
            int num = rand.nextInt(4) + 2;
            for (int k = 0; k < num; ++k) {
                EffectRenderer er = Minecraft.func_71410_x().field_71452_i;
                EntitySmokeFX fx = new EntitySmokeFX(world, (double)pX, (double)pY, (double)pZ, 1.0, 1.0, 1.0);
                fx.func_70538_b(1.0f - rand.nextFloat() * 0.2f, 1.0f - rand.nextFloat() * 0.1f, 1.0f - rand.nextFloat() * 0.2f);
                fx.func_70016_h(velX, -0.06, velZ);
                er.func_78873_a((EntityFX)fx);
            }
        }
    }
}

