/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.Log;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class BlockEnder<T extends TileEntityBase>
extends Block {
    protected final Class<? extends T> teClass;
    protected final String name;
    protected final Class<? extends ItemBlock> itemBlockClass;

    protected BlockEnder(String name, Class<? extends T> teClass) {
        this(name, teClass, null, new Material(MapColor.field_151668_h));
    }

    protected BlockEnder(String name, Class<? extends T> teClass, Material mat) {
        this(name, teClass, null, mat);
    }

    protected BlockEnder(String name, Class<? extends T> teClass, Class<? extends ItemBlock> itemBlockClass) {
        this(name, teClass, itemBlockClass, new Material(MapColor.field_151668_h));
    }

    protected BlockEnder(String name, Class<? extends T> teClass, Class<? extends ItemBlock> itemBlockClass, Material mat) {
        super(mat);
        this.teClass = teClass;
        this.itemBlockClass = itemBlockClass;
        this.name = name;
        this.func_149711_c(0.5f);
        this.func_149663_c(name);
        this.func_149672_a(Block.field_149777_j);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected void init() {
        if (this.itemBlockClass != null) {
            GameRegistry.registerBlock((Block)this, this.itemBlockClass, (String)this.name);
        } else {
            GameRegistry.registerBlock((Block)this, (String)this.name);
        }
        if (this.teClass != null) {
            GameRegistry.registerTileEntity(this.teClass, (String)(this.name + "TileEntity"));
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.teClass != null;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (this.teClass != null) {
            try {
                TileEntityBase te = (TileEntityBase)((Object)this.teClass.newInstance());
                te.init();
                return te;
            }
            catch (Exception e) {
                Log.error("Could not create tile entity for block " + this.name + " for class " + this.teClass);
            }
        }
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ITankAccess) {
            if (FluidUtil.fillInternalTankFromPlayerHandItem(worldIn, pos, playerIn, (ITankAccess)te)) {
                return true;
            }
            if (FluidUtil.fillPlayerHandItemFromInternalTank(worldIn, pos, playerIn, (ITankAccess)te)) {
                return true;
            }
        }
        return this.openGui(worldIn, pos, playerIn, side);
    }

    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public boolean doNormalDrops(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        super.func_180657_a(worldIn, player, pos, state, te);
        worldIn.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.doNormalDrops(world, pos)) {
            return super.getDrops(world, pos, state, fortune);
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getNBTDrop(world, pos, this.getTileEntity(world, pos))});
    }

    public ItemStack getNBTDrop(IBlockAccess world, BlockPos pos, @Nullable T te) {
        int meta = this.func_180651_a(world.func_180495_p(pos));
        ItemStack itemStack = new ItemStack((Block)this, 1, meta);
        this.processDrop(world, pos, te, itemStack);
        return itemStack;
    }

    protected void processDrop(IBlockAccess world, BlockPos pos, @Nullable T te, ItemStack drop) {
    }

    protected T getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if (this.teClass != null && this.teClass.isInstance(te = world.func_175625_s(pos))) {
            return (T)((Object)((TileEntityBase)te));
        }
        return null;
    }

    protected boolean shouldDoWorkThisTick(World world, BlockPos pos, int interval) {
        T te = this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return world.func_82737_E() % (long)interval == 0L;
        }
        return ((TileEntityBase)((Object)te)).shouldDoWorkThisTick(interval);
    }

    protected boolean shouldDoWorkThisTick(World world, BlockPos pos, int interval, int offset) {
        T te = this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return (world.func_82737_E() + (long)offset) % (long)interval == 0L;
        }
        return ((TileEntityBase)((Object)te)).shouldDoWorkThisTick(interval, offset);
    }

    public void setBlockBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.field_149759_B = minX;
        this.field_149760_C = minY;
        this.field_149754_D = minZ;
        this.field_149755_E = maxX;
        this.field_149756_F = maxY;
        this.field_149757_G = maxZ;
    }

    public void setBlockBounds(AxisAlignedBB bb) {
        this.setBlockBounds(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
    }

    public String getName() {
        return this.name;
    }
}

