/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.config;

import com.enderio.core.EnderCore;
import com.enderio.core.api.common.config.IConfigHandler;
import com.enderio.core.common.Lang;
import com.enderio.core.common.event.ConfigFileChangedEvent;
import com.enderio.core.common.util.Bound;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class AbstractConfigHandler
implements IConfigHandler {
    String modid;
    Configuration config;
    private List<Section> sections = new ArrayList<Section>();
    private Section activeSection = null;
    private static Lang fmlLang = new Lang("fml.configgui.tooltip");

    protected AbstractConfigHandler(String modid) {
        this.modid = modid;
        MinecraftForge.EVENT_BUS.register((Object)this);
        EnderCore.instance.configs.add(this);
    }

    @Override
    public final void initialize(File cfg) {
        this.config = new Configuration(cfg);
        this.init();
        this.reloadAllConfigs();
        this.saveConfigFile();
    }

    protected void loadConfigFile() {
        this.config.load();
    }

    protected void saveConfigFile() {
        this.config.save();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(this.modid)) {
            EnderCore.logger.info("Reloading all configs for modid: " + this.modid);
            this.reloadAllConfigs();
            this.saveConfigFile();
        }
    }

    @SubscribeEvent
    public void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.modID.equals(this.modid)) {
            EnderCore.logger.info("Reloading ingame configs for modid: " + this.modid);
            this.loadConfigFile();
            this.reloadIngameConfigs();
            event.setSuccessful();
            this.saveConfigFile();
        }
    }

    private void reloadAllConfigs() {
        this.reloadNonIngameConfigs();
        this.reloadIngameConfigs();
    }

    protected abstract void init();

    protected abstract void reloadNonIngameConfigs();

    protected abstract void reloadIngameConfigs();

    protected Section addSection(String sectionName) {
        return this.addSection(sectionName, sectionName, null);
    }

    protected Section addSection(String sectionName, String langKey) {
        return this.addSection(sectionName, langKey, null);
    }

    protected Section addSection(String sectionName, String langKey, String comment) {
        Section section = new Section(sectionName, langKey);
        if (this.activeSection == null && this.sections.isEmpty()) {
            this.activeSection = section;
        }
        if (comment != null) {
            this.config.addCustomCategoryComment(sectionName, comment);
        }
        return section.register();
    }

    private void checkInitialized() {
        if (this.activeSection == null) {
            throw new IllegalStateException("No section is active!");
        }
    }

    protected void activateSection(String sectionName) {
        Section section = this.getSectionByName(sectionName);
        if (section == null) {
            throw new IllegalArgumentException("Section " + sectionName + " does not exist!");
        }
        this.activateSection(section);
    }

    protected void activateSection(Section section) {
        this.activeSection = section;
    }

    protected Section getSectionByName(String sectionName) {
        for (Section s : this.sections) {
            if (!s.name.equalsIgnoreCase(sectionName)) continue;
            return s;
        }
        return null;
    }

    protected <T> T getValue(String key, T defaultVal) {
        return this.getValue(key, defaultVal, RestartReqs.NONE);
    }

    protected <T> T getValue(String key, T defaultVal, RestartReqs req) {
        return this.getValue(key, null, defaultVal, req);
    }

    protected <T> T getValue(String key, T defaultVal, Bound<? extends Number> bound) {
        return this.getValue(key, null, defaultVal, bound);
    }

    protected <T> T getValue(String key, String comment, T defaultVal) {
        return this.getValue(key, comment, defaultVal, RestartReqs.NONE);
    }

    protected <T> T getValue(String key, String comment, T defaultVal, RestartReqs req) {
        return this.getValue(key, comment, defaultVal, req, null);
    }

    protected <T> T getValue(String key, String comment, T defaultVal, Bound<? extends Number> bound) {
        return this.getValue(key, comment, defaultVal, RestartReqs.NONE, bound);
    }

    protected <T> T getValue(String key, String comment, T defaultVal, RestartReqs req, Bound<? extends Number> bound) {
        Property prop = this.getProperty(key, defaultVal, req);
        prop.comment = comment;
        return this.getValue(prop, defaultVal, bound);
    }

    protected <T> T getValue(Property prop, T defaultVal) {
        return this.getValue(prop, defaultVal, null);
    }

    protected <T> T getValue(Property prop, T defaultVal, Bound<? extends Number> bound) {
        this.checkInitialized();
        if (bound != null) {
            AbstractConfigHandler.setBounds(prop, bound);
        } else {
            bound = Bound.MAX_BOUND;
        }
        AbstractConfigHandler.addCommentDetails(prop, bound);
        if (defaultVal instanceof Integer) {
            Bound<Integer> b = Bound.of(((Number)bound.min).intValue(), ((Number)bound.max).intValue());
            return (T)AbstractConfigHandler.boundValue(prop, b, (Integer)defaultVal);
        }
        if (defaultVal instanceof Float) {
            Bound<Float> b = Bound.of(Float.valueOf(((Number)bound.min).floatValue()), Float.valueOf(((Number)bound.max).floatValue()));
            return (T)AbstractConfigHandler.boundValue(prop, b, (Float)defaultVal);
        }
        if (defaultVal instanceof Double) {
            Bound<Double> b = Bound.of(((Number)bound.min).doubleValue(), ((Number)bound.max).doubleValue());
            return (T)AbstractConfigHandler.boundValue(prop, b, (Double)defaultVal);
        }
        if (defaultVal instanceof Boolean) {
            return (T)Boolean.valueOf(prop.getBoolean());
        }
        if (defaultVal instanceof int[]) {
            return (T)prop.getIntList();
        }
        if (defaultVal instanceof String) {
            return (T)prop.getString();
        }
        if (defaultVal instanceof String[]) {
            return (T)prop.getStringList();
        }
        throw new IllegalArgumentException("default value is not a config value type.");
    }

    static void setBounds(Property prop, Bound<?> bound) throws IllegalArgumentException {
        if (bound.equals(Bound.MAX_BOUND)) {
            return;
        }
        if (prop.getType() == Property.Type.INTEGER) {
            Bound<Integer> b = Bound.of(((Number)bound.min).intValue(), ((Number)bound.max).intValue());
            prop.setMinValue(((Integer)b.min).intValue());
            prop.setMaxValue(((Integer)b.max).intValue());
        } else if (prop.getType() == Property.Type.DOUBLE) {
            Bound<Double> b = Bound.of(((Number)bound.min).doubleValue(), ((Number)bound.max).doubleValue());
            prop.setMinValue(((Double)b.min).doubleValue());
            prop.setMaxValue(((Double)b.max).doubleValue());
        } else {
            throw new IllegalArgumentException(String.format("A mod tried to set bounds %s on a property that was not either of Integer of Double type.", bound));
        }
    }

    static int[] boundIntArr(Property prop, Bound<Integer> bound) {
        int[] prev = prop.getIntList();
        int[] res = new int[prev.length];
        for (int i = 0; i < prev.length; ++i) {
            res[i] = bound.clamp(prev[i]);
        }
        prop.set(res);
        return res;
    }

    static double[] boundDoubleArr(Property prop, Bound<Double> bound) {
        double[] prev = prop.getDoubleList();
        double[] res = new double[prev.length];
        for (int i = 0; i < prev.length; ++i) {
            res[i] = bound.clamp(prev[i]);
        }
        prop.set(res);
        return res;
    }

    static <T extends Number> T boundValue(Property prop, Bound<T> bound, T defVal) throws IllegalArgumentException {
        Bound<Integer> b = bound;
        if (defVal instanceof Integer) {
            return (T)AbstractConfigHandler.boundInt(prop, b);
        }
        if (defVal instanceof Double) {
            return (T)AbstractConfigHandler.boundDouble(prop, b);
        }
        if (defVal instanceof Float) {
            return (T)AbstractConfigHandler.boundFloat(prop, b);
        }
        throw new IllegalArgumentException(bound.min.getClass().getName() + " is not a valid config type.");
    }

    private static Integer boundInt(Property prop, Bound<Integer> bound) {
        prop.set(bound.clamp(prop.getInt()).intValue());
        return prop.getInt();
    }

    private static Double boundDouble(Property prop, Bound<Double> bound) {
        prop.set(bound.clamp(prop.getDouble()).doubleValue());
        return prop.getDouble();
    }

    private static Float boundFloat(Property prop, Bound<Float> bound) {
        return Float.valueOf(AbstractConfigHandler.boundDouble(prop, Bound.of(((Float)bound.min).doubleValue(), ((Float)bound.max).doubleValue())).floatValue());
    }

    static void addCommentDetails(Property prop, Bound<?> bound) {
        prop.comment = prop.comment + (prop.comment.isEmpty() ? "" : "\n");
        if (bound.equals(Bound.MAX_BOUND)) {
            prop.comment = prop.comment + fmlLang.localize("default", prop.isList() ? Arrays.toString(prop.getDefaults()) : prop.getDefault());
        } else {
            boolean minIsInt = ((Number)bound.min).doubleValue() == (double)((Number)bound.min).intValue();
            boolean maxIsInt = ((Number)bound.max).doubleValue() == (double)((Number)bound.max).intValue();
            prop.comment = prop.comment + fmlLang.localize("defaultNumeric", minIsInt ? Integer.valueOf(((Number)bound.min).intValue()) : bound.min, maxIsInt ? Integer.valueOf(((Number)bound.max).intValue()) : bound.max, prop.isList() ? Arrays.toString(prop.getDefaults()) : prop.getDefault());
        }
    }

    protected <T> Property getProperty(String key, T defaultVal) {
        return this.getProperty(key, defaultVal, RestartReqs.NONE);
    }

    protected <T> Property getProperty(String key, T defaultVal, RestartReqs req) {
        this.checkInitialized();
        Section section = this.activeSection;
        Property prop = null;
        if (defaultVal instanceof Integer) {
            prop = this.config.get(section.name, key, ((Integer)defaultVal).intValue());
        }
        if (defaultVal instanceof Boolean) {
            prop = this.config.get(section.name, key, ((Boolean)defaultVal).booleanValue());
        }
        if (defaultVal instanceof int[]) {
            prop = this.config.get(section.name, key, (int[])defaultVal);
        }
        if (defaultVal instanceof String) {
            prop = this.config.get(section.name, key, (String)defaultVal);
        }
        if (defaultVal instanceof String[]) {
            prop = this.config.get(section.name, key, (String[])defaultVal);
        }
        if (defaultVal instanceof Float || defaultVal instanceof Double) {
            double val = defaultVal instanceof Float ? ((Float)defaultVal).doubleValue() : ((Double)defaultVal).doubleValue();
            prop = this.config.get(section.name, key, val);
        }
        if (prop != null) {
            return req.apply(prop);
        }
        throw new IllegalArgumentException("default value is not a config value type.");
    }

    protected boolean shouldHookOnReload() {
        return true;
    }

    @Override
    public void initHook() {
    }

    @Override
    public void postInitHook() {
    }

    @Override
    public final List<Section> getSections() {
        return ImmutableList.copyOf(this.sections);
    }

    @Override
    public final ConfigCategory getCategory(String name) {
        return this.config.getCategory(name);
    }

    @Override
    public final String getModID() {
        return this.modid;
    }

    public static enum RestartReqs {
        NONE,
        REQUIRES_WORLD_RESTART,
        REQUIRES_MC_RESTART;


        public Property apply(Property prop) {
            if (this == REQUIRES_MC_RESTART) {
                prop.setRequiresMcRestart(true);
            } else if (this == REQUIRES_WORLD_RESTART) {
                prop.setRequiresWorldRestart(true);
            }
            return prop;
        }
    }

    public class Section {
        public final String name;
        public final String lang;

        public Section(String name, String lang) {
            this.name = name;
            this.lang = "section." + lang;
        }

        private Section register() {
            AbstractConfigHandler.this.sections.add(this);
            return this;
        }

        public String lc() {
            return this.name.toLowerCase(Locale.US);
        }
    }
}

