/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.handlers;

import com.enderio.core.common.Handlers;
import com.enderio.core.common.enchant.EnchantXPBoost;
import com.enderio.core.common.util.Scheduler;
import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Handlers.Handler
public class XPBoostHandler {
    private static final Method getExperiencePoints = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"e", "func_70693_a", "getExperiencePoints"}, (Class[])new Class[]{EntityPlayer.class});
    private static final String NBT_KEY = "ttCore:xpboost";

    @SubscribeEvent
    public void handleEntityKill(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        Entity killer = event.source.func_76364_f();
        if (!entity.field_70170_p.field_72995_K && killer != null) {
            NBTTagCompound tag;
            if (killer instanceof EntityPlayer) {
                this.scheduleXP((Entity)entity, this.getXPBoost(entity, (EntityPlayer)killer));
            } else if (killer instanceof EntityArrow && ((EntityArrow)killer).field_70250_c instanceof EntityPlayer && (tag = killer.getEntityData()).func_74764_b(NBT_KEY) && tag.func_74762_e(NBT_KEY) >= 0) {
                int level = tag.func_74762_e(NBT_KEY);
                EntityArrow arrow = (EntityArrow)killer;
                this.scheduleXP((Entity)entity, this.getXPBoost(entity, (EntityPlayer)arrow.field_70250_c, level));
            }
        }
    }

    @SubscribeEvent
    public void handleArrowFire(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.entity;
            if (arrow.field_70250_c != null && arrow.field_70250_c instanceof EntityPlayer) {
                arrow.getEntityData().func_74768_a(NBT_KEY, this.getXPBoostLevel(((EntityPlayer)arrow.field_70250_c).func_71045_bC()));
            }
        }
    }

    @SubscribeEvent
    public void handleBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack held = event.getPlayer().func_71045_bC();
        if (held != null) {
            int xp;
            int level = this.getXPBoostLevel(held);
            int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)held);
            if (level >= 0 && (xp = event.state.func_177230_c().getExpDrop((IBlockAccess)event.world, event.pos, fortune)) > 0) {
                event.world.func_72838_d((Entity)new EntityXPOrb(event.world, (double)event.pos.func_177958_n() + 0.5, (double)event.pos.func_177956_o() + 0.5, (double)event.pos.func_177952_p() + 0.5, this.getXPBoost(xp, level)));
            }
        }
    }

    private int getXPBoost(EntityLivingBase killed, EntityPlayer player) {
        return this.getXPBoost(killed, player, this.getXPBoostLevel(player.func_71045_bC()));
    }

    private int getXPBoost(EntityLivingBase killed, EntityPlayer player, int level) {
        if (level >= 0) {
            try {
                int xp = (Integer)getExperiencePoints.invoke((Object)killed, player);
                return this.getXPBoost(xp, level);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return 0;
    }

    private int getXPBoost(int xp, int level) {
        return Math.round((float)xp * ((float)Math.log10(level + 1) * 2.0f));
    }

    private int getXPBoostLevel(ItemStack weapon) {
        if (weapon == null) {
            return -1;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)weapon);
        Iterator iterator = enchants.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Enchantment enchant = Enchantment.func_180306_c((int)i);
            if (enchant != EnchantXPBoost.instance()) continue;
            return (Integer)enchants.get(i);
        }
        return -1;
    }

    private void scheduleXP(Entity entity, int boost) {
        this.scheduleXP(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, boost);
    }

    private void scheduleXP(final World world, final double x, final double y, final double z, final int boost) {
        if (boost <= 0) {
            return;
        }
        Scheduler.instance().schedule(20, new Runnable(){

            @Override
            public void run() {
                world.func_72838_d((Entity)new EntityXPOrb(world, x, y, z, boost));
            }
        });
    }
}

